
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;


public class Light {
	private int x, y, size;
	private boolean hilighted, on;
	private Rectangle bounds;
	public Light(int x, int y, int size){
		this.x=x;
		this.y=y;
		this.setSize(size);
		bounds=new Rectangle(x,y,size, size);
		hilighted=false;
		on=false;
	}
	public void setLocation(int x, int y)
	{
		this.x=x;
		this.y=y;
	}
	public int getX() {return x;}
	public int getY() {return y;}
	public void draw(Graphics g){
		if (hilighted){
			g.setColor(Color.YELLOW);
			g.fillRect(bounds.x-2, bounds.y-2, bounds.width+4, bounds.height+4);
		}
		g.setColor(Color.BLUE);
		if (on)
			g.setColor(Color.CYAN);
		g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
	}
	public void setHighlight(boolean value){
		hilighted=value;
	}
	public boolean isHighlighted()
	{
		return hilighted;
	}
	public void click(){
		on=!on;
	}
	public void on()
	{
		on = true;
	}
	public void off()
	{
		on = false;
	}
	public boolean isOn() {
		return on;
	}
	public boolean contains (int x, int y){
		return bounds.contains(x, y);
	}
	public int getSize() {
		return size;
	}
	public void setSize(int size) {
		this.size = size;
	}
}