

import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
@SuppressWarnings("serial")
public class Tens extends JPanel implements MouseListener, MouseMotionListener
{
    private ArrayList<Tile> tiles;
    private String message;
    public static final int SIZE = 50;
    public static final int WIDTH = 500;
    public static final int HEIGHT = 500;

    public void remove(Tile tile)
    {
        
        // update the message:
        message = "removed ";
    }
    
    public void resetTiles()
    {
        tiles =  new ArrayList<Tile>();
        int n = 30 ; 
        message ="Remove all " + n + " tiles by clicking 2 that add up to 10, anywhere else to reset";
        for (int i = 0; i < n; i++)
        {
            // construct a ne tile and add it to the tiles ArrayList
        }
        repaint();
    }

    public Tens()  // constructor
    {
       
        message = "";
        resetTiles();
        addMouseListener(this);
    }

    public void paintComponent(Graphics g)
    {
        setBackground(new Color(255,220,200) );
        super.paintComponent(g);
        // Adjust location of boxes according to the current panel size
        int width = this.getWidth() - SIZE;
        for( int i = 0; i < tiles.size();  i++ )
        {
            Tile t = tiles.get(i);
        	int x = (i) % (width/SIZE); //column
            
            int y =  (i) / (width/SIZE); //row 
            t.setLocation(SIZE/2 + x*SIZE, SIZE/2 + y*SIZE);
            t.setColumn(x);
            t.setRow(y);
        }
        for( Tile t:tiles)
        {
            t.draw(g);
        }
        g.setColor(Color.BLACK);
        g.drawString(message, 20, 20);
    }

    public static void main(String[] args)
    {
        JFrame window = new JFrame();
        window.setSize(WIDTH, HEIGHT);
        Container c = window.getContentPane();
        c.add(new Tens());

        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.setVisible(true);
    }
    
    
    public void mouseReleased(MouseEvent e) 
    {
        int x = e.getX();
        int y = e.getY();
        for(Tile t:tiles)
        {
            if (t.contains(x,y))
            { 
                // This tile has bee clicked.  
            	// If this the seconded tile, turn it on, and see if is a legal move (ie they add up to 10)
            	// otherwise turn the tile on or off, the user my be deselecting a tile 
                repaint();
                return;
            }
        }
        // If user didn't click on a tile, we reset the game
        resetTiles();
        repaint();
    }
   
    public void mousePressed(MouseEvent e) { }

    public void mouseEntered(MouseEvent e) { }

    public void mouseExited(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { }

	public void mouseDragged(MouseEvent e) {}

	public void mouseMoved(MouseEvent e) 
	{ // hilight a tile if mouse is hovering
		int x=e.getX();
		int y=e.getY();
		for(Tile t: tiles)
			t.setHighlight(t.contains(x, y)) ;
	}
}