import java.awt.Color;
import java.util.ArrayList;
import java.awt.Graphics;

public class Segment
{
    private int x,y,size, dir; 
    private Color color;
    private ArrayList<Turn> turns;
    
    
        
    public Segment(int x, int y, int size, int dir)
    {
        this.x=x;
        this.y=y;
        this.size=size;
        this.dir=dir;
        int r = (int)(255*Math.random());
        int g = (int)(255*Math.random());
        int b = (int)(255*Math.random());
        color = new Color(r,g,b);
        turns = new ArrayList<Turn>();
    }
    public void addTurn(int x, int y, int dir)
    {
        turns.add(new Turn(x,y,dir));
    }
    public void move()
    {
         for(int i=turns.size()-1; i>=0; i--)
         {
             Turn t = turns.get(i);
             if (t.nearby(x,y))
             {
                  dir = t.getDirection();
                  turns.remove(i);
                  break;
             }            
         }
         if (dir==Turn.NORTH)
             y--;
         else if (dir==Turn.SOUTH)
             y++;
         else if (dir==Turn.EAST)
             x++;
         else if (dir==Turn.WEST)
             x--;
         
    }
    public void draw(Graphics g)
    {
        g.setColor(color);
        g.fillOval(x,y,size,size);
        g.setColor(Color.BLACK);
        g.drawOval(x,y,size,size);
    }
    public String toString()
    {
        return "["+x + "][" + y + "] headed "+dir;
    }
}
