import java.awt.*;
import java.util.ArrayList;

public class Snake
{
    // instance variables - replace the example below with your own
    private int x, y, size, dir;
    
    private ArrayList<Segment> body;
    
    /**
     * Constructor for objects of class Snake
     */
    public Snake(int x, int y, int size)
    {
        // initialise instance variables
        this.x = x;
        this.y = y;
        this.size = size;
        dir = Turn.EAST;
        body = new ArrayList<Segment>();
        for (int i=1; i<=13;i++)
        {
            body.add(new Segment(x-i*size,y, size, dir)); 
        }
    }
    public void draw(Graphics g)
    {
        
       g.setColor(Color.GREEN);
       g.fillOval(x, y, size,size); 
       for (Segment s:body)
       {
           s.draw(g);
       }
    }
    
    public void move()
    {
        if (x<-size || x>1200 || y<-size || y>2000)
            return;
        if (dir==Turn.NORTH)
             y--;
        else if (dir==Turn.SOUTH)
             y++;
        else if (dir==Turn.EAST)
             x++;
        else if (dir==Turn.WEST)
             x--;
        for(Segment s:body)
        {
            s.move();
        }
    }
    public void changeDirection(int d)
    {
        dir = d;
        for(Segment s:body)
        {
            s.addTurn(x, y, dir);
        }
    }
}