/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system.impl;

import com.pi4j.system.SystemInfo;
import com.pi4j.system.SystemInfoProvider;
import com.pi4j.system.impl.DefaultSystemInfoProvider;
import com.pi4j.util.ExecUtil;
import java.io.IOException;
import java.text.ParseException;

public class RaspiSystemInfoProvider
extends DefaultSystemInfoProvider
implements SystemInfoProvider {
    public static final short RPI_MODEL_A = 0;
    public static final short RPI_MODEL_B = 1;
    public static final short RPI_MODEL_A_PLUS = 2;
    public static final short RPI_MODEL_B_PLUS = 3;
    public static final short RPI_MODEL_2B = 4;
    public static final short RPI_MODEL_ALPHA = 5;
    public static final short RPI_MODEL_CM = 6;
    public static final short RPI_MODEL_UNKNOWN = 7;
    public static final short RPI_MODEL_3B = 8;
    public static final short RPI_MODEL_ZERO = 9;
    public static final short RPI_MODEL_CM3 = 10;
    public static final short RPI_MODEL_ZERO_W = 12;
    public static final short RPI_MODEL_3B_PLUS = 13;
    public static final short RPI_MODEL_3A_PLUS = 14;
    public static final short RPI_MODEL_CM3_PLUS = 16;
    public static final short RPI_MODEL_4B = 17;
    public static final short RPI_MODEL_400 = 19;
    public static final short RPI_MODEL_CM4 = 20;
    public static final short RPI_RAM_256 = 0;
    public static final short RPI_RAM_512 = 1;
    public static final short RPI_RAM_1024 = 2;
    public static final short RPI_MFG_SONY = 0;
    public static final short RPI_MFG_EGOMAN = 1;
    public static final short RPI_MFG_EMBEST = 2;
    public static final short RPI_MFG_UNKNOWN = 3;
    public static final short RPI_MFG_EMBEST2 = 4;
    public static final short RPI_PROC_BCM2835 = 0;
    public static final short RPI_PROC_BCM2836 = 1;
    public static final short RPI_PROC_BCM2837 = 2;

    private long getClockFrequency(String target) throws IOException, InterruptedException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_clock " + target.trim());
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            String[] parts = line.split("=", 2);
            return Long.parseLong(parts[1].trim());
        }
        throw new UnsupportedOperationException("Invalid command or response.");
    }

    private boolean getCodecEnabled(String codec) throws IOException, InterruptedException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd codec_enabled " + codec);
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            String[] parts = line.split("=", 2);
            return parts[1].trim().equalsIgnoreCase("enabled");
        }
        throw new RuntimeException("Invalid command or response.");
    }

    private float getVoltage(String id) throws IOException, InterruptedException, NumberFormatException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_volts " + id);
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            String[] parts = line.split("[=V]", 3);
            return Float.parseFloat(parts[1]);
        }
        throw new UnsupportedOperationException("Invalid command or response.");
    }

    @Override
    public String getModelName() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("model name");
    }

    @Override
    public String getOsFirmwareBuild() throws IOException, InterruptedException, UnsupportedOperationException {
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd version");
        if (result != null) {
            for (String line : result) {
                if (!line.startsWith("version ")) continue;
                return line.substring(8);
            }
        }
        throw new UnsupportedOperationException("Invalid command or response.");
    }

    @Override
    public String getOsFirmwareDate() throws IOException, InterruptedException, ParseException, UnsupportedOperationException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd version");
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            return line;
        }
        throw new UnsupportedOperationException("Invalid command or response.");
    }

    @Override
    public SystemInfo.BoardType getBoardType() throws IOException, InterruptedException, UnsupportedOperationException {
        String revision = this.getRevision();
        long irevision = Long.parseLong(revision, 16);
        long scheme = irevision >> 23 & 1L;
        long ram = irevision >> 20 & 7L;
        long manufacturer = irevision >> 16 & 0xFL;
        long processor = irevision >> 12 & 0xFL;
        long model = irevision >> 4 & 0xFFL;
        long pcbrev = irevision & 0xFL;
        if (scheme > 0L) {
            switch ((int)model) {
                case 0: {
                    return SystemInfo.BoardType.RaspberryPi_A;
                }
                case 2: {
                    return SystemInfo.BoardType.RaspberryPi_A_Plus;
                }
                case 3: {
                    return SystemInfo.BoardType.RaspberryPi_B_Plus;
                }
                case 4: {
                    return SystemInfo.BoardType.RaspberryPi_2B;
                }
                case 5: {
                    return SystemInfo.BoardType.RaspberryPi_Alpha;
                }
                case 6: {
                    return SystemInfo.BoardType.RaspberryPi_ComputeModule;
                }
                case 7: {
                    return SystemInfo.BoardType.RaspberryPi_Unknown;
                }
                case 8: {
                    return SystemInfo.BoardType.RaspberryPi_3B;
                }
                case 9: {
                    return SystemInfo.BoardType.RaspberryPi_Zero;
                }
                case 10: {
                    return SystemInfo.BoardType.RaspberryPi_ComputeModule3;
                }
                case 12: {
                    return SystemInfo.BoardType.RaspberryPi_ZeroW;
                }
                case 13: {
                    return SystemInfo.BoardType.RaspberryPi_3B_Plus;
                }
                case 14: {
                    return SystemInfo.BoardType.RaspberryPi_3A_Plus;
                }
                case 16: {
                    return SystemInfo.BoardType.RaspberryPi_ComputeModule3_Plus;
                }
                case 17: {
                    return SystemInfo.BoardType.RaspberryPi_4B;
                }
                case 19: {
                    return SystemInfo.BoardType.RaspberryPi_400;
                }
                case 20: {
                    return SystemInfo.BoardType.RaspberryPi_ComputeModule4;
                }
                case 1: {
                    if (pcbrev <= 1L) {
                        return SystemInfo.BoardType.RaspberryPi_B_Rev1;
                    }
                    return SystemInfo.BoardType.RaspberryPi_B_Rev2;
                }
            }
        } else if (scheme == 0L) {
            switch (revision.trim().toLowerCase()) {
                case "Beta": 
                case "0002": 
                case "0003": {
                    return SystemInfo.BoardType.RaspberryPi_B_Rev1;
                }
                case "0004": 
                case "0005": 
                case "0006": {
                    return SystemInfo.BoardType.RaspberryPi_B_Rev2;
                }
                case "0007": 
                case "0008": 
                case "0009": {
                    return SystemInfo.BoardType.RaspberryPi_A;
                }
                case "000d": 
                case "000e": 
                case "000f": {
                    return SystemInfo.BoardType.RaspberryPi_B_Rev2;
                }
                case "0010": {
                    return SystemInfo.BoardType.RaspberryPi_B_Plus;
                }
                case "0011": {
                    return SystemInfo.BoardType.RaspberryPi_ComputeModule;
                }
                case "0012": {
                    return SystemInfo.BoardType.RaspberryPi_A_Plus;
                }
                case "0013": {
                    return SystemInfo.BoardType.RaspberryPi_B_Plus;
                }
                case "0014": {
                    return SystemInfo.BoardType.RaspberryPi_ComputeModule;
                }
                case "0015": {
                    return SystemInfo.BoardType.RaspberryPi_A_Plus;
                }
            }
            return SystemInfo.BoardType.RaspberryPi_Unknown;
        }
        return SystemInfo.BoardType.UNKNOWN;
    }

    @Override
    public float getCpuTemperature() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_temp");
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            String[] parts = line.split("[=']", 3);
            return Float.parseFloat(parts[1]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public float getCpuVoltage() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        return this.getVoltage("core");
    }

    @Override
    public float getMemoryVoltageSDRam_C() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        return this.getVoltage("sdram_c");
    }

    @Override
    public float getMemoryVoltageSDRam_I() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        return this.getVoltage("sdram_i");
    }

    @Override
    public float getMemoryVoltageSDRam_P() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        return this.getVoltage("sdram_p");
    }

    @Override
    public boolean getCodecH264Enabled() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCodecEnabled("H264");
    }

    @Override
    public boolean getCodecMPG2Enabled() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCodecEnabled("MPG2");
    }

    @Override
    public boolean getCodecWVC1Enabled() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCodecEnabled("WVC1");
    }

    @Override
    public long getClockFrequencyArm() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("arm");
    }

    @Override
    public long getClockFrequencyCore() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("core");
    }

    @Override
    public long getClockFrequencyH264() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("h264");
    }

    @Override
    public long getClockFrequencyISP() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("isp");
    }

    @Override
    public long getClockFrequencyV3D() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("v3d");
    }

    @Override
    public long getClockFrequencyUART() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("uart");
    }

    @Override
    public long getClockFrequencyPWM() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("pwm");
    }

    @Override
    public long getClockFrequencyEMMC() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("emmc");
    }

    @Override
    public long getClockFrequencyPixel() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("pixel");
    }

    @Override
    public long getClockFrequencyVEC() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("vec");
    }

    @Override
    public long getClockFrequencyHDMI() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("hdmi");
    }

    @Override
    public long getClockFrequencyDPI() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("dpi");
    }
}

