/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;

public class SerialByteBuffer {
    public static int DEFAULT_BUFFER_SCALE_FACTOR = 2;
    public static int DEFAULT_INITIAL_BUFFER_SIZE = 4096;
    private InputStream stream = new SerialByteBufferInputStream();
    private volatile int writeIndex = 0;
    private volatile int readIndex = 0;
    private byte[] buffer;

    public SerialByteBuffer() {
        this(DEFAULT_INITIAL_BUFFER_SIZE);
    }

    public SerialByteBuffer(int initialCapacity) {
        this.buffer = new byte[initialCapacity];
    }

    public synchronized void clear() {
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public synchronized int capacity() {
        return this.buffer.length;
    }

    public synchronized int remaining() {
        if (this.writeIndex < this.readIndex) {
            return this.readIndex - this.writeIndex - 1;
        }
        return this.buffer.length - 1 - (this.writeIndex - this.readIndex);
    }

    public synchronized int available() {
        if (this.readIndex <= this.writeIndex) {
            return this.writeIndex - this.readIndex;
        }
        return this.buffer.length - (this.readIndex - this.writeIndex);
    }

    private synchronized void resize(int length) {
        int new_capacity;
        int min_capacity = this.buffer.length + length;
        for (new_capacity = this.buffer.length * DEFAULT_BUFFER_SCALE_FACTOR; new_capacity < min_capacity; new_capacity *= DEFAULT_BUFFER_SCALE_FACTOR) {
        }
        byte[] new_buffer = new byte[new_capacity];
        if (this.writeIndex == this.readIndex) {
            this.readIndex = 0;
            this.writeIndex = 0;
        } else if (this.writeIndex > this.readIndex) {
            System.arraycopy(this.buffer, this.readIndex, new_buffer, 0, this.writeIndex - this.readIndex);
            this.readIndex = 0;
            this.writeIndex -= this.readIndex;
        } else {
            int dataLength = this.buffer.length - this.readIndex;
            System.arraycopy(this.buffer, this.readIndex, new_buffer, 0, dataLength);
            System.arraycopy(this.buffer, 0, new_buffer, dataLength, this.writeIndex);
            this.readIndex = 0;
            this.writeIndex = dataLength + this.writeIndex;
        }
        this.buffer = new_buffer;
    }

    public void write(byte[] data) throws IOException, BufferOverflowException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        while (length > 0) {
            int remaining_space = this.remaining();
            if (remaining_space < length) {
                this.resize(length);
            }
            int realLen = Math.min(length, remaining_space);
            int firstLen = Math.min(realLen, this.buffer.length - this.writeIndex);
            int secondLen = Math.min(realLen - firstLen, this.buffer.length - this.readIndex - 1);
            int written = firstLen + secondLen;
            if (firstLen > 0) {
                System.arraycopy(data, offset, this.buffer, this.writeIndex, firstLen);
            }
            if (secondLen > 0) {
                System.arraycopy(data, offset + firstLen, this.buffer, 0, secondLen);
                this.writeIndex = secondLen;
            } else {
                this.writeIndex += written;
            }
            if (this.writeIndex == this.buffer.length) {
                this.writeIndex = 0;
            }
            offset += written;
            length -= written;
        }
        if (length > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception x) {
                throw new IOException("Waiting for available space in buffer interrupted.");
            }
        }
    }

    protected class SerialByteBufferInputStream
    extends InputStream {
        protected SerialByteBufferInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            SerialByteBuffer serialByteBuffer = SerialByteBuffer.this;
            synchronized (serialByteBuffer) {
                return SerialByteBuffer.this.available();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            while (true) {
                SerialByteBuffer serialByteBuffer = SerialByteBuffer.this;
                synchronized (serialByteBuffer) {
                    int available = SerialByteBuffer.this.available();
                    if (available > 0) {
                        int result = SerialByteBuffer.this.buffer[SerialByteBuffer.this.readIndex] & 0xFF;
                        ++SerialByteBuffer.this.readIndex;
                        if (SerialByteBuffer.this.readIndex == SerialByteBuffer.this.buffer.length) {
                            SerialByteBuffer.this.readIndex = 0;
                        }
                        return result;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }

        @Override
        public int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] data, int off, int len) throws IOException {
            while (true) {
                SerialByteBuffer serialByteBuffer = SerialByteBuffer.this;
                synchronized (serialByteBuffer) {
                    int available = SerialByteBuffer.this.available();
                    if (available > 0) {
                        int length = Math.min(len, available);
                        int firstLen = Math.min(length, SerialByteBuffer.this.buffer.length - SerialByteBuffer.this.readIndex);
                        int secondLen = length - firstLen;
                        System.arraycopy(SerialByteBuffer.this.buffer, SerialByteBuffer.this.readIndex, data, off, firstLen);
                        if (secondLen > 0) {
                            System.arraycopy(SerialByteBuffer.this.buffer, 0, data, off + firstLen, secondLen);
                            SerialByteBuffer.this.readIndex = secondLen;
                        } else {
                            SerialByteBuffer.this.readIndex += length;
                        }
                        if (SerialByteBuffer.this.readIndex == SerialByteBuffer.this.buffer.length) {
                            SerialByteBuffer.this.readIndex = 0;
                        }
                        return length;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException, IllegalArgumentException {
            while (true) {
                SerialByteBuffer serialByteBuffer = SerialByteBuffer.this;
                synchronized (serialByteBuffer) {
                    int available = SerialByteBuffer.this.available();
                    if (available > 0) {
                        int firstLen;
                        int length = Math.min((int)n, available);
                        int secondLen = length - (firstLen = Math.min(length, SerialByteBuffer.this.buffer.length - SerialByteBuffer.this.readIndex));
                        SerialByteBuffer.this.readIndex = secondLen > 0 ? secondLen : (SerialByteBuffer.this.readIndex += length);
                        if (SerialByteBuffer.this.readIndex == SerialByteBuffer.this.buffer.length) {
                            SerialByteBuffer.this.readIndex = 0;
                        }
                        return length;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception x) {
                    throw new IOException("Blocking read operation interrupted.");
                }
            }
        }
    }
}

