/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.platform;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.RaspiGpioProvider;
import com.pi4j.io.gpio.SimulatedGpioProvider;
import com.pi4j.io.i2c.I2CFactoryProvider;
import com.pi4j.io.i2c.impl.I2CProviderImpl;
import com.pi4j.platform.PlatformManager;
import com.pi4j.system.SystemInfoProvider;
import com.pi4j.system.impl.RaspiSystemInfoProvider;

public enum Platform {
    RASPBERRYPI("raspberrypi", "Raspberry Pi"),
    SIMULATED("simulated", "Simulated");

    protected String platformId = null;
    protected String label = null;

    private Platform(String platformId, String label) {
        this.platformId = platformId;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String label() {
        return this.getLabel();
    }

    public String getId() {
        return this.platformId;
    }

    public String id() {
        return this.getId();
    }

    public static Platform fromId(String platformId) {
        for (Platform platform : Platform.values()) {
            if (!platform.id().equalsIgnoreCase(platformId)) continue;
            return platform;
        }
        return null;
    }

    public GpioProvider getGpioProvider() {
        return Platform.getGpioProvider(this);
    }

    public static GpioProvider getGpioProvider(Platform platform) {
        switch (PlatformManager.getPlatform()) {
            case RASPBERRYPI: {
                return new RaspiGpioProvider();
            }
            case SIMULATED: {
                return new SimulatedGpioProvider();
            }
        }
        return new RaspiGpioProvider();
    }

    public I2CFactoryProvider getI2CFactoryProvider() {
        return Platform.getI2CFactoryProvider(this);
    }

    public static I2CFactoryProvider getI2CFactoryProvider(Platform platform) {
        return new I2CProviderImpl();
    }

    public SystemInfoProvider getSystemInfoProvider() {
        return Platform.getSystemInfoProvider(this);
    }

    public static SystemInfoProvider getSystemInfoProvider(Platform platform) {
        switch (platform) {
            case RASPBERRYPI: {
                return new RaspiSystemInfoProvider();
            }
        }
        return new RaspiSystemInfoProvider();
    }
}

