/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.w1;

import com.pi4j.io.w1.W1Device;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public abstract class W1BaseDevice
implements W1Device {
    private final String id;
    private String name;
    private File deviceDir;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public W1BaseDevice(File deviceDir) {
        String deviceName;
        try {
            deviceName = new String(Files.readAllBytes(new File(deviceDir, "name").toPath()));
        }
        catch (IOException e) {
            deviceName = deviceDir.getName();
        }
        this.name = deviceName = deviceName.trim();
        this.id = deviceName;
        this.deviceDir = deviceDir;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof W1Device && this.id.equals(((W1Device)obj).getId());
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String getValue() throws IOException {
        return new String(Files.readAllBytes(new File(this.deviceDir, "w1_slave").toPath()));
    }
}

