/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import java.util.EnumSet;

public enum PinEdge {
    NONE(0, "none"),
    BOTH(1, "both"),
    RISING(2, "rising"),
    FALLING(3, "falling");

    private final int value;
    private final String name;

    private PinEdge(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static PinEdge getEdge(int edge) {
        for (PinEdge item : PinEdge.values()) {
            if (item.getValue() != edge) continue;
            return item;
        }
        return null;
    }

    public static EnumSet<PinEdge> all() {
        return EnumSet.allOf(PinEdge.class);
    }
}

