import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.Timer;

public class PackManTester extends JPanel implements KeyListener, ActionListener, MouseListener
{
    public static int WIDTH=800;
    public static int HEIGHT=600;
    public static final int NORTH=0, SOUTH=1, EAST=2, WEST=3;
    private PackMan pm;
    private Level lev1;
    private Timer chewTimer, moveTimer;
    private String message, message2;
    private int moveCnt;

    public PackManTester(){
        int size =50;
        lev1 = new Level(3, 7,  100,  size,  size);
        lev1.noExit(0,1,SOUTH);
        lev1.noExit(0,2,SOUTH);
        lev1.noExit(0,5,SOUTH);
        lev1.noExit(1,0,EAST);
        lev1.noExit(1,1,WEST);
        lev1.noExit(1,1,NORTH);
        lev1.noExit(1,2,NORTH);
        lev1.noExit(1,2,SOUTH);
        lev1.noExit(1,3,EAST);
        lev1.noExit(1,3,SOUTH);
        lev1.noExit(1,4,WEST);
        lev1.noExit(1,4,SOUTH);
        lev1.noExit(1,5,NORTH);
        lev1.noExit(1,5,EAST);
        lev1.noExit(1,6,WEST);
        lev1.noExit(2,2,NORTH);
        lev1.noExit(2,3,NORTH);
        lev1.noExit(2,4,NORTH);
        pm = new PackMan(lev1, 2, 0);
        chewTimer = new Timer(150, this);
        moveTimer = new Timer(50,this);
        chewTimer.start();
        moveTimer.start();
        message = "Click a cell to show info";
        message2 = pm.toString();
        moveCnt=0;
        
    }

    public static void main(String[] args) {
        PackManTester app= new PackManTester();
        JFrame window = new JFrame("Level Tester");
        window.setSize(WIDTH, HEIGHT);
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.getContentPane().add(app);
        // remember to add Key Listeners for the game interface
        window.addKeyListener(app);
        window.getContentPane().addMouseListener(app);
        window.setVisible(true);

    }

    public void paintComponent(Graphics g){
        super.paintComponent(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, getWidth(),getHeight());
        lev1.draw(g);
        pm.draw(g);
        g.setColor(Color.BLACK);
        g.drawString(message, 50,50);
        message2 = pm.toString();
        g.drawString(message2, 50,70);
        g.drawString("moves: "+moveCnt + " Crumbs: "+ lev1.crumbsLeft(), 50,90);
    }

    public void actionPerformed(ActionEvent e) {

        if (e.getSource()==chewTimer){
            pm.changeMouth();
        } else if (e.getSource()==moveTimer) {
            pm.move();
            moveCnt++;
        }
        
        repaint();
    }

    public void keyTyped(KeyEvent e) {}  

    public void keyPressed(KeyEvent e) {}

    public void keyReleased(KeyEvent e) {
        int keyCode=e.getKeyCode();

        if(keyCode == 37){
            //left
            pm.setDirection(Cell.WEST);
        } else if (keyCode ==38){
            // up
            pm.setDirection(Cell.NORTH);
        } else if (keyCode ==39){
            // right
            pm.setDirection(Cell.EAST);
        }else if (keyCode ==40){
            // down
            pm.setDirection(Cell.SOUTH);
        } 
        
        repaint();

    }
    @Override
	public void mouseClicked(MouseEvent e) {

	}
	@Override
	public void mousePressed(MouseEvent e) {

	}
	@Override
	public void mouseReleased(MouseEvent e) {
		int x=e.getX();
		int y=e.getY();
		message = lev1.getCell(x,y).toString();
		
		repaint();
	}
	@Override
	public void mouseEntered(MouseEvent e) {

	}
	@Override
	public void mouseExited(MouseEvent e) {

	}

}