import java.awt.*;

public class Cell
{
    public static final int NORTH=0, SOUTH=1, EAST=2, WEST=3;

    public static final int GAP = 5;

    private boolean[] canExit;// NSEW true if an exit
    private boolean visited;
    private int x, y, size;

    public Cell (int x, int y , int size)
    {
        this.x = x;
        this.y = y;
        this.size = size;
        canExit = new boolean[4];
        visited = false;
        setAllExits(true);    
    }

    public boolean canExit(int dir){
        return canExit[dir];
    }

    public void noExit(int dir) {
        canExit[dir] = false;
    }

    public void exit(int dir) {
        canExit[dir] = true;
    }

    public void setAllExits(boolean b){
        for(int i = 0; i < canExit.length; i++)
            canExit[i] = b;
    }

    public int getX(){
        return x+size/2; //center
    }

    public int getY(){
        return y+size/2;
    }

    public boolean beenVisited(){
        return visited;
    }

    public void setVisited(boolean v)
    {
        visited = v;
    }

    public boolean contains(int x0, int y0){
        return (x0 >= x) && (x0 <= x + size) &&
        (y0 >= y) && (y0 <= y + size);
    }

    public void draw(Graphics g)
    {
        g.setColor(Color.BLACK);
        g.fillRect(x, y, size, size);
        if( !visited){
            g.setColor(Color.YELLOW);
            g.fillRect(x+size/2, y+size/2, GAP,GAP);
        }
        g.setColor(Color.MAGENTA.darker());
        if(!canExit[NORTH]){
            g.fillRect(x, y, size, GAP);
        }
        if(!canExit[SOUTH]){
            g.fillRect(x, y+size-GAP, size, GAP);
        }
        if(!canExit[EAST]){
            g.fillRect(x+size-GAP, y, GAP, size);
        }
        if(!canExit[WEST]){
            g.fillRect(x, y, GAP, size);
        }
    }

    public String toString(){
        String result="";
        result += "("+x +", "+y+") Exits: ";
        if(canExit[Cell.NORTH]) 
            result += "N ";
        if(canExit[Cell.SOUTH]) 
            result += "S ";
        if(canExit[Cell.EAST]) 
            result += "E ";
        if(canExit[Cell.WEST]) 
            result += "W ";
        return result;
    }
}