import java.awt.*;

public class Level
{
    private Cell[][] grid;
    private int rows, cols, top, left, size;
    public Level(int rows, int cols, int top, int left, int size)
    {
        this.rows = rows;
        this.cols = cols;
        this.top = top;
        this.left = left;
        this.size = size;
        grid = new Cell[rows][cols];
        for(int r=0; r<rows; r++)
            for(int c = 0; c < cols; c++){
                grid[r][c] = new Cell(left+c*size, top+r*size ,size);
            }
        for(int c =0; c < cols; c++){
            grid[0][c].noExit(Cell.NORTH);
            grid[rows-1][c].noExit(Cell.SOUTH);
        }
        for(int r=0; r < rows; r++){
            grid[r][0].noExit(Cell.WEST);
            grid[r][cols-1].noExit(Cell.EAST);
        }
    }

    public void noExit(int r, int c, int dir)
    {
        grid[r][c].noExit(dir);
    }

    public int getXbyCol(int col){
        return grid[0][col].getX();
    }

    public int getYbyRow(int row){
        return grid[row][0].getY();
    }

    public int getSize(){
        return size;
    }

    public Cell getCell(int x, int y){
        for(Cell[] row:grid)
            for(Cell c : row)
                if (c.contains(x,y))
                    return c;
        return null;               
    }

    /**
     * CountCrumbs returns the number of unvisited cells
     */

    public int crumbsLeft(){
        int n=0;
        for(Cell[] row:grid)
            for(Cell c : row)
                if (!c.beenVisited())
                    n++;
        return n;

    }

    public void draw(Graphics g)
    {
        for(Cell[] row:grid)
            for(Cell c : row)
                c.draw(g);
    }
}