/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import kareltherobot.Directions;
import kareltherobot.RobotWorldWindow;
import kareltherobot.World;
import kareltherobot.WorldBuilderInterface;

public class WorldBuilder
extends Frame
implements Directions,
WorldBuilderInterface {
    private TextField streets = new TextField(5);
    private TextField avenues = new TextField(5);
    private Button horizontalWall = new Button("Horizontal Wall");
    private Button verticalWall = new Button("Vertical Wall");
    private Button beeper = new Button("Beeper");
    private Button selectedButton = null;
    private WindowAdapter closer = null;
    private Button save = new Button("Save");
    private Button open = new Button("Open");
    private Button showSpeed = new Button("Hide Speedcontrol");
    private String filename = "untitled.kwld";
    private String directory = "";
    private boolean isDirty = false;
    private FileDialog openDialog = new FileDialog((Frame)this, null, 0);
    private FileDialog saveDialog = new FileDialog((Frame)this, null, 1);
    private Color buttonColor = null;
    private Color selectedColor = new Color(192, 255, 192);
    private Label statusBar = new Label("");
    private Label whereBar = new Label("");
    private Label fileBar = new Label(this.filename);
    private Button clearAll = new Button("Clear World");
    private ItemDropper itemDropper = new ItemDropper();
    private static final RobotWorldWindow view = World.view();
    private Font displayFont = new Font("Dialog", 0, 14);
    private BeeperScaler beeperScaler = new BeeperScaler();
    private HorizontalWallScaler horizontalWallScaler = new HorizontalWallScaler();
    private VerticalWallScaler verticalWallScaler = new VerticalWallScaler();
    private MouseWatcher mouseWatcher = new MouseWatcher();
    private static final int fromTop = 10;
    static WorldBuilder wb = null;

    public void cleanUp() {
        if (this.isDirty) {
            this.saveFile();
        }
    }

    public WorldBuilder(boolean showSpeedControl) {
        super("World Builder");
        if (!showSpeedControl) {
            this.showSpeed.setLabel("Show Speedcontrol");
        }
        this.setSize(120, 380);
        this.setLocation(560, 30);
        this.closer = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WorldBuilder.this.cleanUp();
                System.exit(0);
            }
        };
        this.addWindowListener(this.closer);
        view.replaceCloser(this.closer);
        Panel toolPanel = new Panel(new GridLayout(3, 1, 0, 20));
        this.add("Center", toolPanel);
        Panel spacerPanel = new Panel(new GridLayout(2, 1, 0, 5));
        Panel sizePanel = new Panel(new GridLayout(2, 2, 0, 5));
        Label filler1 = new Label();
        filler1.setVisible(false);
        Label filler2 = new Label();
        filler2.setVisible(false);
        Panel innerSpacerPanel = new Panel(new GridLayout(2, 1, 0, 5));
        innerSpacerPanel.add(new Label("Controller"));
        innerSpacerPanel.add(this.showSpeed);
        spacerPanel.add(innerSpacerPanel);
        spacerPanel.add(sizePanel);
        toolPanel.add("North", spacerPanel);
        this.streets.setFont(this.displayFont);
        this.avenues.setFont(this.displayFont);
        sizePanel.add(this.streets);
        sizePanel.add(new Label("Streets"));
        sizePanel.add(this.avenues);
        sizePanel.add(new Label("Avenues"));
        Panel buttonPanel = new Panel(new GridLayout(5, 1, 0, 5));
        toolPanel.add("Center", buttonPanel);
        this.whereBar.setAlignment(1);
        this.statusBar.setAlignment(1);
        this.whereBar.setFont(this.displayFont);
        this.statusBar.setFont(this.displayFont);
        buttonPanel.add(this.statusBar);
        buttonPanel.add(this.whereBar);
        buttonPanel.add(this.horizontalWall);
        buttonPanel.add(this.verticalWall);
        buttonPanel.add(this.beeper);
        Panel savePanel = new Panel(new GridLayout(5, 1, 0, 5));
        toolPanel.add("South", savePanel);
        this.fileBar.setFont(this.displayFont);
        this.showSpeed.addActionListener(new SpeedListener());
        savePanel.add(this.save);
        savePanel.add(this.open);
        savePanel.add(this.fileBar);
        savePanel.add(this.clearAll);
        this.streets.addActionListener(new RowListener());
        this.avenues.addActionListener(new ColumnListener());
        this.horizontalWall.addActionListener(new HorizontalListener());
        this.verticalWall.addActionListener(new VerticalListener());
        this.beeper.addActionListener(new BeeperListener());
        this.save.addActionListener(new SaveListener());
        this.open.addActionListener(new OpenListener());
        this.clearAll.addActionListener(new ClearListener());
        this.buttonColor = this.beeper.getBackground();
        view.addMouseListener(this.itemDropper);
        this.streets.setText("" + World.numberOfStreets());
        this.avenues.setText("" + World.numberOfAvenues());
        view.attachMouseMotionListener(this.mouseWatcher);
        this.pack();
        this.setVisible(true);
        view.showControlDialog(showSpeedControl);
        World.registerBuilder(this);
    }

    public void updateStreetsAvenues(int streets, int avenues) {
        this.streets.setText("" + streets);
        this.avenues.setText("" + avenues);
    }

    private void saveFile() {
        this.saveDialog.setDirectory(this.directory);
        this.saveDialog.setFile(this.filename);
        this.saveDialog.show();
        String result = this.saveDialog.getFile();
        if (result != null) {
            this.filename = result;
            this.fileBar.setText(result);
            this.directory = this.saveDialog.getDirectory();
            World.saveWorld(this.directory, this.filename);
            this.isDirty = false;
        }
    }

    public static void main(String[] args) {
        World.setVisible(true);
        wb = new WorldBuilder(false);
    }

    private class ClearListener
    implements ActionListener {
        ClearListener() {
        }

        public void actionPerformed(ActionEvent e) {
            World.reset();
            WorldBuilder.this.isDirty = true;
            WorldBuilder.this.streets.setText("" + World.numberOfStreets());
            WorldBuilder.this.avenues.setText("" + World.numberOfAvenues());
            WorldBuilder.this.repaint();
            view.repaint();
        }
    }

    private class SpeedListener
    implements ActionListener {
        SpeedListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().indexOf("Show") > -1) {
                WorldBuilder.this.showSpeed.setLabel("Hide Speedcontrol");
                view.showControlDialog(true);
            } else {
                WorldBuilder.this.showSpeed.setLabel("Show Speedcontrol");
                view.showControlDialog(false);
            }
        }
    }

    private class HorizontalListener
    implements ActionListener {
        HorizontalListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Button thisButton = (Button)e.getSource();
            if (thisButton != WorldBuilder.this.selectedButton) {
                ((Button)e.getSource()).setBackground(WorldBuilder.this.selectedColor);
                WorldBuilder.this.beeper.setBackground(Color.lightGray);
                WorldBuilder.this.verticalWall.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = thisButton;
                WorldBuilder.this.statusBar.setText("Horizontal Wall");
                WorldBuilder.this.mouseWatcher.setScaler(WorldBuilder.this.horizontalWallScaler);
                WorldBuilder.this.itemDropper.setScaler(WorldBuilder.this.horizontalWallScaler);
                view.ewCursor();
            } else {
                thisButton.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = null;
                WorldBuilder.this.statusBar.setText("");
                WorldBuilder.this.whereBar.setText("");
                WorldBuilder.this.mouseWatcher.setScaler(null);
                WorldBuilder.this.itemDropper.setScaler(null);
                view.defaultCursor();
            }
        }
    }

    private class VerticalListener
    implements ActionListener {
        VerticalListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Button thisButton = (Button)e.getSource();
            if (thisButton != WorldBuilder.this.selectedButton) {
                ((Button)e.getSource()).setBackground(WorldBuilder.this.selectedColor);
                WorldBuilder.this.beeper.setBackground(Color.lightGray);
                WorldBuilder.this.horizontalWall.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = thisButton;
                WorldBuilder.this.statusBar.setText("Vertical Wall");
                WorldBuilder.this.mouseWatcher.setScaler(WorldBuilder.this.verticalWallScaler);
                WorldBuilder.this.itemDropper.setScaler(WorldBuilder.this.verticalWallScaler);
                view.nsCursor();
            } else {
                thisButton.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = null;
                WorldBuilder.this.statusBar.setText("");
                WorldBuilder.this.whereBar.setText("");
                WorldBuilder.this.mouseWatcher.setScaler(null);
                WorldBuilder.this.itemDropper.setScaler(null);
                view.defaultCursor();
            }
        }
    }

    private class BeeperListener
    implements ActionListener {
        BeeperListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Button thisButton = (Button)e.getSource();
            if (thisButton != WorldBuilder.this.selectedButton) {
                ((Button)e.getSource()).setBackground(WorldBuilder.this.selectedColor);
                WorldBuilder.this.horizontalWall.setBackground(Color.lightGray);
                WorldBuilder.this.verticalWall.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = thisButton;
                WorldBuilder.this.statusBar.setText("Beeper");
                WorldBuilder.this.mouseWatcher.setScaler(WorldBuilder.this.beeperScaler);
                WorldBuilder.this.itemDropper.setScaler(WorldBuilder.this.beeperScaler);
                view.beeperCursor();
            } else {
                thisButton.setBackground(Color.lightGray);
                WorldBuilder.this.selectedButton = null;
                WorldBuilder.this.statusBar.setText("");
                WorldBuilder.this.whereBar.setText("");
                WorldBuilder.this.mouseWatcher.setScaler(null);
                WorldBuilder.this.itemDropper.setScaler(null);
                view.defaultCursor();
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            WorldBuilder.this.saveFile();
            WorldBuilder.this.repaint();
        }
    }

    private class OpenListener
    implements ActionListener {
        OpenListener() {
        }

        public void actionPerformed(ActionEvent e) {
            WorldBuilder.this.openDialog.setDirectory(WorldBuilder.this.directory);
            WorldBuilder.this.openDialog.setFile(WorldBuilder.this.filename);
            WorldBuilder.this.openDialog.show();
            String result = WorldBuilder.this.openDialog.getFile();
            if (result != null) {
                WorldBuilder.this.filename = result;
                WorldBuilder.this.fileBar.setText(result);
                WorldBuilder.this.directory = WorldBuilder.this.openDialog.getDirectory();
                World.readWorld(WorldBuilder.this.directory, WorldBuilder.this.filename);
                WorldBuilder.this.streets.setText("" + World.numberOfStreets());
                WorldBuilder.this.avenues.setText("" + World.numberOfAvenues());
                view.repaint();
                WorldBuilder.this.isDirty = true;
            }
        }
    }

    private class RowListener
    implements ActionListener {
        RowListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                World.setSize(Integer.parseInt(WorldBuilder.this.streets.getText()), World.numberOfAvenues());
                view.setVisible(false);
                view.repaint();
                view.setVisible(true);
                WorldBuilder.this.isDirty = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class ColumnListener
    implements ActionListener {
        ColumnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                World.setSize(World.numberOfStreets(), Integer.parseInt(WorldBuilder.this.avenues.getText()));
                view.setVisible(false);
                view.repaint();
                view.setVisible(true);
                WorldBuilder.this.isDirty = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    static interface MouseScaler {
        public void scale(int var1, int var2, Point var3);

        public void dropItem(MouseEvent var1);
    }

    private class BeeperScaler
    implements MouseScaler {
        private Point where = new Point();

        BeeperScaler() {
        }

        public void scale(int rawx, int rawy, Point result) {
            int scale = (view.bottom() - 10) / World.numberOfStreets();
            if (scale == 0) {
                scale = 1;
            }
            result.x = (rawx - view.left() + scale / 2) / scale;
            result.y = (view.bottom() - rawy + scale / 2) / scale;
        }

        public void dropItem(MouseEvent evt) {
            boolean add;
            this.scale(evt.getX(), evt.getY(), this.where);
            int street = this.where.y;
            int avenue = this.where.x;
            if (street < 1 || avenue < 1 || street > World.numberOfStreets() || avenue > World.numberOfAvenues()) {
                return;
            }
            int keyMask = 2;
            if (System.getProperty("os.name").indexOf("Mac") > -1) {
                keyMask = 8;
            }
            boolean bl = add = (evt.getModifiers() & keyMask) == 0;
            if ((evt.getModifiers() & 1) != 0) {
                World.clearBeepers(street, avenue);
            } else {
                World.placeBeepers(street, avenue, add ? 1 : -1);
            }
            view.setVisible(true);
        }
    }

    private class HorizontalWallScaler
    implements MouseScaler {
        private Point where = new Point();

        HorizontalWallScaler() {
        }

        public void scale(int rawx, int rawy, Point result) {
            int scale = (view.bottom() - 10) / World.numberOfStreets();
            if (scale == 0) {
                scale = 1;
            }
            result.x = (rawx - view.left() + scale / 2) / scale;
            result.y = (view.bottom() - rawy) / scale;
        }

        public void dropItem(MouseEvent evt) {
            boolean add;
            this.scale(evt.getX(), evt.getY(), this.where);
            int street = this.where.y;
            int avenue = this.where.x;
            if (street < 1 || avenue < 1 || street > World.numberOfStreets() - 1 || avenue > World.numberOfAvenues()) {
                return;
            }
            int keyMask = 2;
            if (System.getProperty("os.name").indexOf("Mac") > -1) {
                keyMask = 8;
            }
            boolean bl = add = (evt.getModifiers() & keyMask) == 0;
            if (add) {
                World.placeEWWall(street, avenue, 1);
            } else {
                World.removeEWWall(street, avenue);
            }
            view.setVisible(true);
        }
    }

    private class VerticalWallScaler
    implements MouseScaler {
        private Point where = new Point();

        VerticalWallScaler() {
        }

        public void scale(int rawx, int rawy, Point result) {
            int scale = (view.bottom() - 10) / World.numberOfStreets();
            if (scale == 0) {
                scale = 1;
            }
            result.x = (rawx - view.left()) / scale;
            result.y = (view.bottom() - rawy + scale / 2) / scale;
        }

        public void dropItem(MouseEvent evt) {
            boolean add;
            this.scale(evt.getX(), evt.getY(), this.where);
            int street = this.where.y;
            int avenue = this.where.x;
            if (street < 1 || avenue < 1 || street > World.numberOfStreets() || avenue > World.numberOfAvenues() - 1) {
                return;
            }
            int keyMask = 2;
            if (System.getProperty("os.name").indexOf("Mac") > -1) {
                keyMask = 8;
            }
            boolean bl = add = (evt.getModifiers() & keyMask) == 0;
            if (add) {
                World.placeNSWall(street, avenue, 1);
            } else {
                World.removeNSWall(street, avenue);
            }
            view.setVisible(true);
        }
    }

    private class MouseWatcher
    extends MouseMotionAdapter {
        private MouseScaler scaler = null;
        private Point where = new Point();

        MouseWatcher() {
        }

        public void mouseMoved(MouseEvent evt) {
            if (this.scaler != null) {
                this.scaler.scale(evt.getX(), evt.getY(), this.where);
                int avenue = this.where.x;
                int street = this.where.y;
                if (avenue < 1) {
                    avenue = 1;
                }
                if (street < 1) {
                    street = 1;
                }
                WorldBuilder.this.whereBar.setText(street + ", " + avenue);
                WorldBuilder.this.repaint();
            }
        }

        public void setScaler(MouseScaler scaler) {
            this.scaler = scaler;
        }
    }

    private class ItemDropper
    extends MouseAdapter {
        private MouseScaler scaler = null;

        ItemDropper() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.scaler != null) {
                this.scaler.dropItem(evt);
                view.repaint();
                WorldBuilder.this.isDirty = true;
            }
        }

        public void setScaler(MouseScaler scaler) {
            this.scaler = scaler;
        }
    }
}

