/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import kareltherobot.Directions;
import kareltherobot.World;

public class UrRobot
extends Observable
implements Directions,
Runnable {
    private Vector senders = new Vector();
    private int nextSender = 0;
    private boolean pausing = false;
    private boolean userLevelPausing = false;
    BufferedReader sysin = new BufferedReader(new InputStreamReader(System.in));
    private static final int on = 2;
    private static final int off = 1;
    private static final int crashed = 0;
    private int[] loc = new int[4];
    private int beepers;
    private Color badgeColor = null;
    private Directions.Direction direction;
    private int moves = 0;
    private int state = 2;
    private boolean isVisible = true;
    private int idNumber;
    private static final int threshhold = 10;
    private static int numberOfRobots = 0;
    private StateObject initialState;

    public void turnLeft() {
        if (this.state == 2) {
            this.pause("turnLeft");
            this.direction = this.direction.rotate(-1);
            StateObject s = new StateObject(1);
            this.setChanged();
            this.notifyObservers(s);
            this.sleep();
        }
    }

    public void move() {
        if (this.state == 2) {
            this.pause("move");
            boolean crashed = false;
            this.normalize();
            switch (this.direction.points()) {
                case 3: {
                    if (!World.checkEWWall(this.loc[3], this.loc[0])) break;
                    crashed = this.crash("Tried to walk through an East West wall");
                    break;
                }
                case 0: {
                    if (!World.checkNSWall(this.loc[3], this.loc[0])) break;
                    crashed = this.crash("Tried to walk through a North South wall");
                    break;
                }
                case 1: {
                    if (!World.checkEWWall(this.loc[3] - 1, this.loc[0])) break;
                    crashed = this.crash("Tried to walk through an East West wall");
                    break;
                }
                case 2: {
                    if (!World.checkNSWall(this.loc[3], this.loc[0] - 1)) break;
                    crashed = this.crash("Tried to walk through a North South wall");
                }
            }
            if (!crashed) {
                int n = this.direction.points();
                this.loc[n] = this.loc[n] + 1;
                ++this.moves;
                if (this.moves > 10) {
                    this.normalize();
                }
            }
            this.validate();
            StateObject s = new StateObject(0);
            this.setChanged();
            this.notifyObservers(s);
            this.sleep();
        }
    }

    public void pickBeeper() {
        if (this.state == 2) {
            this.pause("pickBeeper");
            this.normalize();
            boolean crashed = false;
            if (!World.checkBeeper(this.loc[3], this.loc[0])) {
                crashed = this.crash("No beepers to pick");
            }
            if (!crashed) {
                if (this.beepers != -1) {
                    ++this.beepers;
                }
                World.placeBeepers(this.loc[3], this.loc[0], -1);
            }
            StateObject s = new StateObject(2);
            this.setChanged();
            this.notifyObservers(s);
            this.sleep();
        }
    }

    public void putBeeper() {
        if (this.state == 2) {
            this.pause("putBeeper");
            this.normalize();
            if (this.beepers == 0) {
                this.crash("No beepers to put.");
                StateObject s = new StateObject(3);
                this.setChanged();
                this.notifyObservers(s);
                return;
            }
            if (this.beepers != -1) {
                --this.beepers;
            }
            if (!this.validate()) {
                if (this.beepers != -1) {
                    ++this.beepers;
                }
            } else {
                World.placeBeepers(this.loc[3], this.loc[0], 1);
                StateObject s = new StateObject(3);
                this.setChanged();
                this.notifyObservers(s);
            }
            this.sleep();
        }
    }

    public void turnOff() {
        this.pause("turnOff");
        if (this.state == 2) {
            System.out.println("Robot " + this.idNumber + ": Turning off");
            this.state = 1;
            StateObject s = new StateObject(4);
            this.setChanged();
            this.notifyObservers(s);
            this.sleep();
        }
    }

    public World world() {
        return World.asObject();
    }

    public Enumeration neighbors() {
        Vector<UrRobot> v = new Vector<UrRobot>();
        Enumeration all = World.robots();
        while (all.hasMoreElements()) {
            UrRobot r = (UrRobot)all.nextElement();
            if (r == this || !r.areYouHere(this.street(), this.avenue())) continue;
            v.addElement(r);
        }
        return v.elements();
    }

    public String getNextCommunication() {
        if (this.senders.size() == 0) {
            return null;
        }
        int count = 0;
        while (count < this.senders.size()) {
            if (this.nextSender >= this.senders.size()) {
                this.nextSender = 0;
            }
            BufferedReader in = (BufferedReader)this.senders.elementAt(this.nextSender);
            try {
                ++this.nextSender;
                if (in.ready()) {
                    return in.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++count;
            this.sleep();
        }
        return null;
    }

    public String waitForCommunication() {
        if (this.senders.size() == 0) {
            return null;
        }
        while (true) {
            if (this.nextSender >= this.senders.size()) {
                this.nextSender = 0;
            }
            BufferedReader in = (BufferedReader)this.senders.elementAt(this.nextSender);
            try {
                ++this.nextSender;
                if (in.ready()) {
                    return in.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sleep();
        }
    }

    public String waitForNextCommunication() {
        if (this.senders.size() == 0) {
            return null;
        }
        while (true) {
            if (this.nextSender >= this.senders.size()) {
                this.nextSender = 0;
            }
            BufferedReader in = (BufferedReader)this.senders.elementAt(this.nextSender);
            try {
                ++this.nextSender;
                return in.readLine();
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public BufferedWriter connectTo(UrRobot other, ConnectStrategy strat) throws IOException {
        PipedOutputStream out = new PipedOutputStream();
        BufferedWriter result = new BufferedWriter(new OutputStreamWriter(out));
        other.acceptConnectionFrom(this, out, strat);
        return result;
    }

    public synchronized void acceptConnectionFrom(UrRobot sender, PipedOutputStream s, ConnectStrategy strat) throws IOException {
        BufferedReader manager = new BufferedReader(new InputStreamReader(new PipedInputStream(s)));
        if (strat != null) {
            strat.action(sender, this, manager);
        } else {
            this.senders.addElement(manager);
        }
    }

    public synchronized void acceptConnection(PipedOutputStream s, ConnectStrategy strat) throws IOException {
        BufferedReader manager = new BufferedReader(new InputStreamReader(new PipedInputStream(s)));
        if (strat != null) {
            strat.action(null, this, manager);
        } else {
            this.senders.addElement(manager);
        }
    }

    public void send(BufferedWriter other, String s) throws IOException {
        other.write(String.valueOf(s) + '\n');
        other.flush();
    }

    public void run() {
    }

    final void pause(String message) {
        if (this.pausing) {
            System.out.println("RobotID " + this.idNumber + " is about to " + message + ".");
            try {
                this.sysin.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void userPause(String message) {
        if (this.userLevelPausing) {
            System.out.println("RobotID " + this.idNumber + " is about to " + message + ".");
            try {
                this.sysin.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final void setPause(boolean pausing) {
        this.pausing = pausing;
    }

    public final void setUserPause(boolean pausing) {
        this.userLevelPausing = pausing;
    }

    public UrRobot(int street, int avenue, Directions.Direction direction, int beepers, Color badgeColor) {
        this.loc[3] = street;
        this.loc[1] = 0;
        this.loc[0] = avenue;
        this.loc[2] = 0;
        this.direction = direction;
        this.beepers = beepers;
        this.validate();
        this.idNumber = UrRobot.incrementRobots();
        this.state = 2;
        this.initialState = new StateObject(-1);
        this.badgeColor = badgeColor;
        World.addRobot(this);
        this.sleep();
        this.sleep();
    }

    public UrRobot(int street, int avenue, Directions.Direction direction, int beepers) {
        this(street, avenue, direction, beepers, null);
    }

    final Color badgeColor() {
        return this.badgeColor;
    }

    final void restoreInitialState() {
        this.loc[3] = this.initialState.street;
        this.loc[1] = 0;
        this.loc[0] = this.initialState.avenue;
        this.loc[2] = 0;
        this.direction = this.initialState.direction;
        this.beepers = this.initialState.beepers;
        this.state = 2;
        this.showState("Restoring ");
        this.setChanged();
        this.notifyObservers(this.initialState);
        this.sleep();
    }

    public final String toString() {
        this.normalize();
        return "RobotID " + this.idNumber + " at (street: " + this.loc[3] + ") (avenue: " + this.loc[0] + ") (beepers: " + (this.beepers >= 0 ? "" + this.beepers : "infinite") + ") ( direction: " + this.direction.toString() + (this.state == 2 ? ") on" : ") off");
    }

    private String direction(int d) {
        switch (d) {
            case 0: {
                return "East";
            }
            case 1: {
                return "South";
            }
            case 2: {
                return "West";
            }
            case 3: {
                return "North";
            }
        }
        return "ERROR";
    }

    protected void sleep() {
        try {
            Thread.sleep(10 * World.delay());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void showState(String s) {
        this.normalize();
        System.out.println(String.valueOf(s) + this);
    }

    final boolean areYouHere(int street, int avenue) {
        this.normalize();
        return this.loc[3] == street && this.loc[0] == avenue;
    }

    private boolean validate() {
        this.normalize();
        if (this.beepers < -1) {
            return !this.crash("Robot has negative beepers");
        }
        if (this.loc[3] < 1) {
            return !this.crash("Robot tried to move through South boundary wall");
        }
        if (this.loc[0] < 1) {
            return !this.crash("Robot tried to move through West boundary wall");
        }
        return true;
    }

    private boolean crash(String s) {
        this.state = 0;
        this.showState("Error shutoff: ");
        System.out.println(s);
        return true;
    }

    final boolean crashed() {
        return this.state == 0;
    }

    private void pauseExit() {
        try {
            this.sysin.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }

    private void normalize() {
        this.moves = 0;
        this.loc[3] = this.loc[3] - this.loc[1];
        this.loc[1] = 0;
        this.loc[0] = this.loc[0] - this.loc[2];
        this.loc[2] = 0;
    }

    final int beepers() {
        return this.beepers;
    }

    final Directions.Direction direction() {
        return this.direction;
    }

    final int street() {
        return this.loc[3] - this.loc[1];
    }

    final int avenue() {
        return this.loc[0] - this.loc[2];
    }

    final boolean running() {
        return this.state == 2;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final void setVisible(boolean visible) {
        if (visible != this.isVisible) {
            this.setChanged();
            this.isVisible = visible;
        }
    }

    private static synchronized int incrementRobots() {
        return numberOfRobots++;
    }

    public static interface ConnectStrategy {
        public void action(UrRobot var1, UrRobot var2, BufferedReader var3);
    }

    static interface Action {
        public static final int move = 0;
        public static final int turnLeft = 1;
        public static final int pickBeeper = 2;
        public static final int putBeeper = 3;
        public static final int turnOff = 4;
        public static final int initial = -1;
    }

    final class StateObject
    implements Serializable {
        private int street;
        private int avenue;
        private Directions.Direction direction;
        private int beepers;
        private int lastAction;

        public StateObject(int lastAction) {
            this.street = UrRobot.this.loc[3] - UrRobot.this.loc[1];
            this.avenue = UrRobot.this.loc[0] - UrRobot.this.loc[2];
            this.direction = UrRobot.this.direction;
            this.beepers = UrRobot.this.beepers;
            this.lastAction = lastAction;
        }

        public int street() {
            return this.street;
        }

        public int avenue() {
            return this.avenue;
        }

        public Directions.Direction direction() {
            return this.direction;
        }

        public int beepers() {
            return this.beepers;
        }

        public int lastAction() {
            return this.lastAction;
        }
    }
}

