/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import kareltherobot.Directions;
import kareltherobot.UrRobot;
import kareltherobot.World;
import kareltherobot.WorldBuilder;

public class RobotWorldWindow
extends Frame {
    private static int scaleInset = 0;
    private static int oldScale = 0;
    private static Toolkit toolkit = null;
    private static boolean isMac = false;
    private static Image karelImageNOnBase;
    private static Image karelImageSOnBase;
    private static Image karelImageEOnBase;
    private static Image karelImageWOnBase;
    private static Image karelImageNOffBase;
    private static Image karelImageSOffBase;
    private static Image karelImageEOffBase;
    private static Image karelImageWOffBase;
    private static Image nsCursorImage;
    private static Image ewCursorImage;
    private static Image beeperCursorImage;
    private static Image nsDeleteImage;
    private static Image ewDeleteImage;
    private static Image beeperDeleteImage;
    private static Cursor defaultCursor;
    private static Cursor nsCursor;
    private static Cursor ewCursor;
    private static Cursor beeperCursor;
    private static Cursor nsDelete;
    private static Cursor ewDelete;
    private static Cursor beeperDelete;
    private WindowListener closer = new CloseListener();
    private static Image[] robotsOn;
    private static Image[] robotsOff;
    private Label whereBar = new Label("");
    private MouseWatcher mouser = new MouseWatcher();
    private static int worldHeight;
    private static int worldWidth;
    private static Dimension lastSize;
    private static final int fromTop = 10;
    private static final int leftEdge = 15;
    private static final int delta = 5;
    private static Color streetColor;
    private static Color wallColor;
    private static Color beeperColor;
    private static Color backgroundColor;
    private static int bottomEdge;
    private static final int wallSize = 4;
    private ViewCanvas worldView = null;
    private int delay = 100;
    private ControlThread controlThread = new ControlThread();
    private Font displayFont = new Font("Dialog", 0, 14);
    static /* synthetic */ Class class$0;

    static {
        robotsOn = new Image[4];
        robotsOff = new Image[4];
        worldHeight = 0;
        worldWidth = worldHeight + 80;
        lastSize = new Dimension(0, 0);
        streetColor = Color.red.darker();
        wallColor = Color.black;
        beeperColor = Color.black;
        backgroundColor = Color.white;
        bottomEdge = worldHeight - 15 - 5;
    }

    public Dimension getPreferredSize() {
        return new Dimension(worldWidth + 10, worldHeight + 20);
    }

    public Dimension innerDimension() {
        Dimension base = this.getSize();
        base.height -= 20;
        base.width -= 10;
        return base;
    }

    public RobotWorldWindow() {
        this(Toolkit.getDefaultToolkit().getScreenSize().height - 20);
    }

    public RobotWorldWindow(int height) {
        super("Karel J. Robot");
        Class<?> clazz;
        worldHeight = height;
        worldWidth = height + 80;
        this.setSize(worldWidth + 10, worldHeight + 20);
        this.setLocation(5, 10);
        ScrollPane scroller = new ScrollPane();
        this.worldView = new ViewCanvas();
        scroller.add(this.worldView);
        this.add("Center", scroller);
        this.addWindowListener(this.closer);
        this.setBackground(Color.white);
        this.repaint();
        this.controlThread.start();
        toolkit = this.getToolkit();
        String suffix = ".png";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        karelImageNOnBase = toolkit.getImage(clazz2.getResource("kareln" + suffix));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        karelImageSOnBase = toolkit.getImage(clazz3.getResource("karels" + suffix));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        karelImageEOnBase = toolkit.getImage(clazz4.getResource("karele" + suffix));
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        karelImageWOnBase = toolkit.getImage(clazz5.getResource("karelw" + suffix));
        MediaTracker track = new MediaTracker(this);
        track.addImage(karelImageNOnBase, 0);
        track.addImage(karelImageSOnBase, 1);
        track.addImage(karelImageEOnBase, 2);
        track.addImage(karelImageWOnBase, 3);
        try {
            track.waitForID(0);
            track.waitForID(1);
            track.waitForID(2);
            track.waitForID(3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        karelImageNOffBase = toolkit.getImage(clazz.getResource("karelnOff" + suffix));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        karelImageSOffBase = toolkit.getImage(clazz6.getResource("karelsOff" + suffix));
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        karelImageEOffBase = toolkit.getImage(clazz7.getResource("kareleOff" + suffix));
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        karelImageWOffBase = toolkit.getImage(clazz8.getResource("karelwOff" + suffix));
        track.addImage(karelImageNOffBase, 0);
        track.addImage(karelImageSOffBase, 1);
        track.addImage(karelImageEOffBase, 2);
        track.addImage(karelImageWOffBase, 3);
        try {
            track.waitForID(0);
            track.waitForID(1);
            track.waitForID(2);
            track.waitForID(3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.scaleAllRobotImages();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                RobotWorldWindow.this.scaleAllRobotImages();
                RobotWorldWindow.this.repaint();
            }
        });
        nsCursor = defaultCursor = this.getCursor();
        ewCursor = defaultCursor;
        beeperCursor = defaultCursor;
        nsDelete = defaultCursor;
        ewDelete = defaultCursor;
        beeperDelete = defaultCursor;
        try {
            Class<?> clazz9 = class$0;
            if (clazz9 == null) {
                try {
                    clazz9 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            nsCursorImage = toolkit.getImage(clazz9.getResource("nscursor.gif"));
            Class<?> clazz10 = class$0;
            if (clazz10 == null) {
                try {
                    clazz10 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ewCursorImage = toolkit.getImage(clazz10.getResource("ewcursor.gif"));
            Class<?> clazz11 = class$0;
            if (clazz11 == null) {
                try {
                    clazz11 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            beeperCursorImage = toolkit.getImage(clazz11.getResource("beepercursor.gif"));
            Class<?> clazz12 = class$0;
            if (clazz12 == null) {
                try {
                    clazz12 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            nsDeleteImage = toolkit.getImage(clazz12.getResource("nsdeletecursor.gif"));
            Class<?> clazz13 = class$0;
            if (clazz13 == null) {
                try {
                    clazz13 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ewDeleteImage = toolkit.getImage(clazz13.getResource("ewdeletecursor.gif"));
            Class<?> clazz14 = class$0;
            if (clazz14 == null) {
                try {
                    clazz14 = class$0 = Class.forName("kareltherobot.RobotWorldWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            beeperDeleteImage = toolkit.getImage(clazz14.getResource("beeperdeletecursor.gif"));
            track = new MediaTracker(this);
            track.addImage(nsCursorImage, 0);
            track.addImage(ewCursorImage, 1);
            track.addImage(beeperCursorImage, 2);
            track.addImage(nsDeleteImage, 3);
            track.addImage(ewDeleteImage, 4);
            track.addImage(beeperDeleteImage, 5);
            try {
                track.waitForID(0);
                track.waitForID(1);
                track.waitForID(2);
                track.waitForID(3);
                track.waitForID(4);
                track.waitForID(5);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ewCursor = toolkit.createCustomCursor(ewCursorImage, new Point(8, 8), "ewWall");
            nsCursor = toolkit.createCustomCursor(nsCursorImage, new Point(8, 8), "nsWall");
            beeperCursor = toolkit.createCustomCursor(beeperCursorImage, new Point(8, 8), "beeper");
            ewDelete = toolkit.createCustomCursor(ewDeleteImage, new Point(8, 8), "ewDelete");
            nsDelete = toolkit.createCustomCursor(nsDeleteImage, new Point(8, 8), "nsDelete");
            beeperDelete = toolkit.createCustomCursor(beeperDeleteImage, new Point(8, 8), "beeperDelete");
        }
        catch (Throwable e1) {
            System.out.println("Failed to create the custom cursors.");
        }
        this.setVisible(false);
    }

    public final void showControlDialog(boolean show) {
        this.controlThread.showDialog(show);
    }

    public synchronized void scaleAllRobotImages() {
        int scaleVal;
        int scale = (this.bottom() - 10) / World.numberOfStreets();
        if (scale == 0) {
            scale = 1;
        }
        if ((scaleVal = scale * 7 / 9) < 10) {
            scaleVal = 10;
        }
        if (oldScale > 0 && 4 * oldScale < 5 * scaleVal && 5 * scaleVal < 6 * oldScale) {
            return;
        }
        scaleInset = scaleVal;
        RobotWorldWindow.robotsOn[3] = karelImageNOnBase.getScaledInstance(scaleVal, -1, 4);
        RobotWorldWindow.robotsOn[1] = karelImageSOnBase.getScaledInstance(scaleVal, -1, 4);
        RobotWorldWindow.robotsOn[0] = karelImageEOnBase.getScaledInstance(scaleVal, -1, 4);
        RobotWorldWindow.robotsOn[2] = karelImageWOnBase.getScaledInstance(scaleVal, -1, 4);
        RobotWorldWindow.robotsOff[3] = karelImageNOffBase.getScaledInstance(scaleVal, -1, 4);
        RobotWorldWindow.robotsOff[1] = karelImageSOffBase.getScaledInstance(scaleVal, -1, 4);
        RobotWorldWindow.robotsOff[0] = karelImageEOffBase.getScaledInstance(scaleVal, -1, 4);
        RobotWorldWindow.robotsOff[2] = karelImageWOffBase.getScaledInstance(scaleVal, -1, 4);
        MediaTracker track = new MediaTracker(this);
        int i = 0;
        while (i < 4) {
            track.addImage(robotsOn[i], 2 * i);
            track.addImage(robotsOff[i], 2 * i + 1);
            ++i;
        }
        try {
            i = 0;
            while (i < 8) {
                track.waitForID(i);
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        oldScale = scaleVal;
        this.repaint();
    }

    public void addMouseListener(MouseListener m) {
        this.worldView.addMouseListener(m);
    }

    public void attachMouseMotionListener(MouseMotionListener m) {
        this.worldView.addMouseMotionListener(m);
    }

    void defaultCursor() {
        this.toFront();
        this.worldView.setCursor(defaultCursor);
        this.worldView.requestFocus();
    }

    void ewCursor() {
        this.toFront();
        this.worldView.setCursor(ewCursor);
        this.worldView.setVisible(true);
        this.worldView.requestFocus();
    }

    void nsCursor() {
        this.toFront();
        this.worldView.setCursor(nsCursor);
        this.worldView.requestFocus();
    }

    void beeperCursor() {
        this.toFront();
        this.worldView.setCursor(beeperCursor);
        this.worldView.requestFocus();
    }

    public final void setMac(boolean mac) {
        isMac = mac;
    }

    public void enableStop() {
        this.controlThread.stop.setEnabled(true);
    }

    public static int scaleInset() {
        return scaleInset;
    }

    public Image scale(Image aRobot, int scaleVal, int hint) {
        return aRobot.getScaledInstance(scaleVal, -1, hint);
    }

    void replaceCloser(WindowListener other) {
        this.removeWindowListener(this.closer);
        this.closer = other;
        this.addWindowListener(this.closer);
    }

    public void resetControl() {
        this.controlThread.reset();
    }

    public void reset() {
        this.controlThread.stop.setLabel("Resume");
        World.stop();
        this.worldView.repaint();
    }

    private Rectangle getClip(UrRobot.StateObject so) {
        Rectangle r = new Rectangle();
        int street = so.street();
        int avenue = so.avenue();
        int adjust = RobotWorldWindow.scaleInset() / 2;
        int logicalBottomEdge = this.logicalBottomEdge();
        int scale = this.getScale();
        r.x = 15 + (avenue - 1) * scale - adjust;
        r.y = logicalBottomEdge - (street + 1) * scale - adjust;
        int cells = 2;
        if (so.lastAction() == 0) {
            cells = 3;
        }
        r.height = cells * scale;
        r.width = cells * scale;
        return r;
    }

    public synchronized void prepareToDraw(UrRobot.StateObject so) {
        Rectangle r = this.getClip(so);
        this.worldView.repaint(r.x, r.y, r.width, r.height);
    }

    public synchronized void repaint() {
        this.worldView.repaint();
    }

    public int getScale() {
        int result;
        int worldHeight = this.innerDimension().height;
        int streets = World.numberOfStreets();
        if (streets <= 0) {
            streets = 10;
        }
        if ((result = (worldHeight - 15 - 10) / streets) <= 0) {
            result = 1;
        }
        return result;
    }

    private int logicalBottomEdge() {
        return this.innerDimension().height - 15 - 10;
    }

    public int bottom() {
        return this.logicalBottomEdge() + 5;
    }

    public int left() {
        return 15;
    }

    private int wallSize() {
        int result = 4;
        int streets = World.numberOfStreets();
        if (streets > 20) {
            result /= 2;
        }
        if (streets > 60) {
            result /= 2;
        }
        if (streets == 0) {
            result = 1;
        }
        return result;
    }

    static final void setStreetColor(Color c) {
        if (c != null) {
            streetColor = c;
        }
    }

    static final void setWallColor(Color c) {
        if (c != null) {
            wallColor = c;
        }
    }

    static final void setBeeperColor(Color c) {
        if (c != null) {
            beeperColor = c;
        }
    }

    final void setBackgroundColor(Color c) {
        this.worldView.setBackground(c);
        backgroundColor = c;
    }

    Canvas worldCanvas() {
        return this.worldView;
    }

    private class CornerScaler
    implements WorldBuilder.MouseScaler {
        CornerScaler() {
        }

        public void scale(int rawx, int rawy, Point result) {
            RobotWorldWindow view = World.view();
            int scale = (view.bottom() - 10) / World.numberOfStreets();
            if (scale == 0) {
                scale = 1;
            }
            result.x = (rawx - view.left() + scale / 2) / scale;
            result.y = (view.bottom() - rawy + scale / 2) / scale;
        }

        public void dropItem(MouseEvent evt) {
        }
    }

    private class MouseWatcher
    extends MouseMotionAdapter {
        private WorldBuilder.MouseScaler scaler;
        private Point where;

        MouseWatcher() {
            this.scaler = new CornerScaler();
            this.where = new Point();
        }

        public void mouseMoved(MouseEvent evt) {
            this.scaler.scale(evt.getX(), evt.getY(), this.where);
            int avenue = this.where.x;
            int street = this.where.y;
            if (avenue < 1) {
                avenue = 1;
            }
            if (street < 1) {
                street = 1;
            }
            RobotWorldWindow.this.whereBar.setText(street + ", " + avenue);
            RobotWorldWindow.this.whereBar.repaint();
        }
    }

    class ControlThread
    extends Thread {
        private Dialog frame = new Dialog(new Frame("empty"), "Control");
        private Button stop = new Button("Resume");
        private Panel controls = new Panel();
        private Scrollbar speed = new Scrollbar(0);
        private boolean started = false;

        public ControlThread() {
            this.stop.setEnabled(false);
            this.frame.setResizable(false);
        }

        public void run() {
            SpeedListener speedListener = new SpeedListener();
            this.speed.addAdjustmentListener(speedListener);
            this.frame.setLocation(450, 400);
            this.frame.setSize(210, 90);
            this.controls.setSize(200, 80);
            this.controls.setLayout(new GridLayout(2, 2));
            this.frame.add(this.controls);
            this.speed.setValues(0, 0, 0, 101);
            this.speed.setSize(300, this.speed.getSize().height);
            this.speed.setValue(100 - World.delay());
            this.stop.addActionListener(new StopListener());
            RobotWorldWindow.this.whereBar.setBackground(Color.white);
            this.controls.add(this.stop);
            RobotWorldWindow.this.whereBar.setFont(RobotWorldWindow.this.displayFont);
            this.controls.add(RobotWorldWindow.this.whereBar);
            Label speedLabel = new Label("Set Speed", 2);
            speedLabel.setFont(RobotWorldWindow.this.displayFont);
            this.controls.add(speedLabel);
            Panel spacer = new Panel();
            spacer.setLayout(new BorderLayout());
            spacer.add((Component)new Panel(), "North");
            spacer.add(this.speed);
            spacer.add((Component)new Panel(), "South");
            this.controls.add(spacer);
            this.frame.addWindowListener(new DialogHider());
            this.frame.setVisible(false);
        }

        public final void showDialog(boolean show) {
            this.controls.setVisible(show);
            this.controls.repaint();
            this.frame.setVisible(show);
        }

        public final void doStop() {
            this.frame.setVisible(false);
            this.stop();
        }

        public void reset() {
            this.started = false;
        }

        private class DialogHider
        extends WindowAdapter {
            DialogHider() {
            }

            public void windowClosing(WindowEvent e) {
                ControlThread.this.showDialog(false);
            }
        }

        private class SpeedListener
        implements AdjustmentListener {
            SpeedListener() {
            }

            public void adjustmentValueChanged(AdjustmentEvent e) {
                RobotWorldWindow.this.delay = ControlThread.this.speed.getValue();
                World.setDelay(100 - RobotWorldWindow.this.delay);
                RobotWorldWindow.this.worldView.repaint();
            }
        }

        private class StopListener
        implements ActionListener {
            StopListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Stop")) {
                    ControlThread.this.stop.setLabel("Resume");
                    World.stop();
                } else {
                    ControlThread.this.stop.setLabel("Stop");
                    if (ControlThread.this.started) {
                        World.resume();
                    } else {
                        ControlThread.this.started = true;
                        World.startThreads();
                    }
                }
            }
        }
    }

    class ViewCanvas
    extends Canvas
    implements Directions {
        private int x1 = 0;
        private int y1 = 0;
        private int x2 = 0;
        private int y2 = 0;
        private int oldStreet = 0;
        private int oldAvenue = 0;
        private int oldFacing = 3;
        private boolean moved = false;
        private boolean turned = false;
        private boolean picked = false;
        private Image offScreen = null;
        private Graphics osg = null;
        private boolean resized = false;
        private int scale;

        public ViewCanvas() {
            this.addMouseMotionListener(RobotWorldWindow.this.mouser);
            this.addKeyListener(new ControlKeyListener());
        }

        public boolean isDoubleBuffered() {
            return true;
        }

        public Dimension getPreferredSize() {
            int bigWidth;
            Dimension world = RobotWorldWindow.this.innerDimension();
            int width = world.width;
            int height = world.height - 30;
            width = bigWidth = RobotWorldWindow.this.getScale() * (World.numberOfAvenues() + 1);
            return new Dimension(width, height);
        }

        public synchronized void paint(Graphics g) {
            int streets = World.numberOfStreets();
            int avenues = World.numberOfAvenues();
            int wallSize = RobotWorldWindow.this.wallSize();
            lastSize = RobotWorldWindow.this.innerDimension();
            if (streets <= 0) {
                streets = 10;
            }
            if (avenues <= 0) {
                avenues = 10;
            }
            int bottomEdge = RobotWorldWindow.this.logicalBottomEdge();
            this.scale = RobotWorldWindow.this.getScale();
            this.setBackground(backgroundColor);
            g.setColor(streetColor);
            int i = 1;
            while (i <= streets) {
                g.drawLine(15 + this.scale / 2, bottomEdge - i * this.scale, 15 + avenues * this.scale, bottomEdge - i * this.scale);
                ++i;
            }
            i = 1;
            while (i <= avenues) {
                g.drawLine(15 + i * this.scale, bottomEdge - this.scale / 2, 15 + i * this.scale, bottomEdge - streets * this.scale);
                ++i;
            }
            g.setColor(wallColor);
            g.fillRect(15 - wallSize + this.scale / 2, bottomEdge - streets * this.scale, wallSize, streets * this.scale - this.scale / 2 + wallSize);
            g.fillRect(15 + this.scale / 2, bottomEdge - this.scale / 2, avenues * this.scale - this.scale / 2, wallSize);
            g.setColor(Color.black);
            if (streets <= 50) {
                i = 0;
                int x = 0;
                int y = bottomEdge - this.scale / 2 + 15;
                i = 1;
                while (i <= avenues) {
                    g.drawString(String.valueOf(i), 15 + i * this.scale - 5, y);
                    ++i;
                }
                x = 15 - wallSize + this.scale / 2 - 15;
                i = 1;
                while (i <= streets) {
                    g.drawString(String.valueOf(i), x, bottomEdge - i * this.scale + 5);
                    ++i;
                }
            }
            g.setColor(wallColor);
            Enumeration e = World.ewWalls();
            while (e.hasMoreElements()) {
                World.IntPair p = (World.IntPair)e.nextElement();
                this.drawHWall(p.street(), p.avenue(), g);
            }
            e = World.nsWalls();
            while (e.hasMoreElements()) {
                World.IntPair p = (World.IntPair)e.nextElement();
                this.drawVWall(p.street(), p.avenue(), g);
            }
            e = World.beepers();
            g.setColor(beeperColor);
            while (e.hasMoreElements()) {
                World.BeeperCell p = (World.BeeperCell)e.nextElement();
                this.drawBeeper(p.street(), p.avenue(), p.number(), g, g.getColor());
            }
            e = World.robots();
            while (e.hasMoreElements()) {
                UrRobot p = (UrRobot)e.nextElement();
                this.drawRobot(p, g);
            }
        }

        public final synchronized void update(Graphics g) {
            super.update(g);
            this.resized = !RobotWorldWindow.this.innerDimension().equals(lastSize);
            int worldHeight = RobotWorldWindow.this.innerDimension().height;
            int worldWidth = 15 + (World.numberOfAvenues() + 1) * RobotWorldWindow.this.getScale();
            if (this.resized) {
                this.offScreen = null;
                this.resized = false;
            }
            if (this.resized || this.offScreen == null) {
                this.offScreen = this.createImage(worldWidth, worldHeight);
                this.resized = false;
            }
            if (this.offScreen != null) {
                if (this.osg != null) {
                    this.osg.dispose();
                }
                this.osg = this.offScreen.getGraphics();
                if (isMac) {
                    this.osg.setClip(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                    if (this.moved || this.turned) {
                        this.drawOldRobot(this.oldStreet, this.oldAvenue, this.oldFacing, true, this.osg, this.getBackground());
                    }
                    if (this.picked) {
                        this.drawBeeper(this.oldStreet, this.oldAvenue, 1, this.osg, this.getBackground());
                    }
                }
                this.paint(this.osg);
                if (isMac) {
                    g.drawImage(this.offScreen, this.x1, this.y1, this.x2, this.y2, this.x1, this.y1, this.x2, this.y2, null);
                    this.moved = false;
                    this.turned = false;
                    this.picked = false;
                } else {
                    g.drawImage(this.offScreen, 0, 0, null);
                    this.offScreen.flush();
                    this.offScreen = null;
                }
            }
        }

        private void drawHWall(int s, int a, Graphics g) {
            g.fillRect(15 + a * this.scale - this.scale / 2, RobotWorldWindow.this.logicalBottomEdge() - s * this.scale - this.scale / 2, this.scale, RobotWorldWindow.this.wallSize());
        }

        private void drawVWall(int s, int a, Graphics g) {
            g.fillRect(15 + a * this.scale + this.scale / 2, RobotWorldWindow.this.logicalBottomEdge() - s * this.scale - this.scale / 2, RobotWorldWindow.this.wallSize(), this.scale + RobotWorldWindow.this.wallSize());
        }

        private synchronized void drawBeeper(int s, int a, int howMany, Graphics g, Color c) {
            Color oldColor = g.getColor();
            g.setColor(c);
            g.fillOval(15 + a * this.scale - this.scale / 4, RobotWorldWindow.this.logicalBottomEdge() - s * this.scale - this.scale / 4, this.scale / 2, this.scale / 2);
            g.setColor(Color.white);
            String name = howMany > 0 ? "" + howMany : "oo";
            g.drawString(name, 15 + a * this.scale - this.scale / 8, RobotWorldWindow.this.logicalBottomEdge() - s * this.scale + this.scale / 8);
            g.setColor(oldColor);
        }

        private synchronized Point locationToPixels(int street, int avenue) {
            int scale = RobotWorldWindow.this.getScale();
            int x = 15 + scale * avenue;
            int y = RobotWorldWindow.this.logicalBottomEdge() - scale * street;
            return new Point(x, y);
        }

        private synchronized Rectangle robotCenter(UrRobot karel) {
            int s = karel.street();
            int a = karel.avenue();
            Point center = this.locationToPixels(s, a);
            int size = RobotWorldWindow.this.getScale() / 12;
            if (size < 2) {
                size = 2;
            }
            if (karel.crashed()) {
                ++size;
            }
            return new Rectangle(center.x - size, center.y - size, 2 * size, 2 * size);
        }

        private synchronized void drawRobot(UrRobot karel, Graphics g) {
            if (!karel.isVisible()) {
                return;
            }
            int s = karel.street();
            int a = karel.avenue();
            Image[] robots = robotsOn;
            if (!karel.running()) {
                robots = robotsOff;
            }
            Image karelImage = robots[karel.direction().points()];
            int adjust = RobotWorldWindow.scaleInset() / 2;
            g.drawImage(karelImage, 15 + a * this.scale - adjust, RobotWorldWindow.this.logicalBottomEdge() - s * this.scale - adjust, this);
            if (karel.badgeColor() != null) {
                g.setColor(karel.badgeColor());
                Rectangle center = this.robotCenter(karel);
                g.fillRect(center.x, center.y, center.width, center.height);
                g.setColor(Color.black);
                if (karel.badgeColor().equals(Color.black)) {
                    g.setColor(Color.red);
                }
                g.drawRect(center.x, center.y, center.width, center.height);
                if (karel.crashed()) {
                    this.drawCrashed(center, g);
                }
            } else if (karel.crashed()) {
                g.setColor(Color.white);
                Rectangle center = this.robotCenter(karel);
                g.drawRect(center.x, center.y, center.width, center.height);
                this.drawCrashed(center, g);
            }
        }

        private void drawCrashed(Rectangle center, Graphics g) {
            g.drawLine(center.x, center.y, center.x + center.width, center.y + center.width);
            g.drawLine(center.x, center.y + center.width, center.x + center.width, center.y);
        }

        private synchronized void drawOldRobot(int s, int a, int facing, boolean running, Graphics g, Color c) {
            Image[] robots = robotsOn;
            if (!running) {
                robots = robotsOff;
            }
            Image karelImage = robots[facing];
            g.drawImage(karelImage, 15 + a * this.scale - 12, RobotWorldWindow.this.logicalBottomEdge() - s * this.scale - 12, null);
        }

        class ControlKeyListener
        implements KeyListener {
            ControlKeyListener() {
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                boolean shiftOrControl;
                Cursor cursor = ViewCanvas.this.getCursor();
                boolean shift = e.isShiftDown();
                boolean control = e.isControlDown();
                boolean bl = shiftOrControl = shift || control;
                if (!shiftOrControl) {
                    return;
                }
                if (control && cursor.equals(ewCursor)) {
                    ViewCanvas.this.setCursor(ewDelete);
                } else if (control && cursor.equals(nsCursor)) {
                    ViewCanvas.this.setCursor(nsDelete);
                } else if (shiftOrControl && cursor.equals(beeperCursor)) {
                    ViewCanvas.this.setCursor(beeperDelete);
                }
            }

            public void keyReleased(KeyEvent e) {
                boolean shiftOrControl;
                Cursor cursor = ViewCanvas.this.getCursor();
                int code = e.getKeyCode();
                boolean control = code == 17;
                boolean shift = code == 16;
                boolean bl = shiftOrControl = shift || control;
                if (!shiftOrControl) {
                    return;
                }
                if (control && cursor.equals(ewDelete)) {
                    ViewCanvas.this.setCursor(ewCursor);
                } else if (control && cursor.equals(nsDelete)) {
                    ViewCanvas.this.setCursor(nsCursor);
                } else if (shiftOrControl && cursor.equals(beeperDelete)) {
                    ViewCanvas.this.setCursor(beeperCursor);
                }
            }
        }
    }

    private class CloseListener
    extends WindowAdapter {
        CloseListener() {
        }

        public void windowClosing(WindowEvent e) {
            e.getWindow().setVisible(false);
            RobotWorldWindow.this.controlThread.doStop();
            e.getWindow().dispose();
            World.killBuilder();
            World.stop();
            System.exit(0);
        }
    }
}

