/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.util.Enumeration;
import junit.framework.TestCase;
import kareltherobot.Directions;
import kareltherobot.UrRobot;
import kareltherobot.World;

public class KJRTest
extends TestCase
implements Directions {
    public KJRTest(String name) {
        super(name);
    }

    private boolean frontIsClear(UrRobot robot) {
        int street = robot.street();
        int avenue = robot.avenue();
        switch (robot.direction().points()) {
            case 3: {
                if (!World.checkEWWall(street, avenue)) break;
                return false;
            }
            case 0: {
                if (!World.checkNSWall(street, avenue)) break;
                return false;
            }
            case 1: {
                if (!World.checkEWWall(street - 1, avenue)) break;
                return false;
            }
            case 2: {
                if (!World.checkNSWall(street, avenue - 1)) break;
                return false;
            }
        }
        return true;
    }

    public final void assertFacingNorth(UrRobot robot) {
        KJRTest.assertTrue((String)"Not facing North", (robot.direction() == North ? 1 : 0) != 0);
    }

    public final void assertNotFacingNorth(UrRobot robot) {
        KJRTest.assertTrue((String)"Facing North", (robot.direction() != North ? 1 : 0) != 0);
    }

    public final void assertFacingEast(UrRobot robot) {
        KJRTest.assertTrue((String)"Not facing East", (robot.direction() == East ? 1 : 0) != 0);
    }

    public final void assertNotFacingEast(UrRobot robot) {
        KJRTest.assertTrue((String)"Facing East", (robot.direction() != East ? 1 : 0) != 0);
    }

    public final void assertFacingSouth(UrRobot robot) {
        KJRTest.assertTrue((String)"Not facing South", (robot.direction() == South ? 1 : 0) != 0);
    }

    public final void assertNotFacingSouth(UrRobot robot) {
        KJRTest.assertTrue((String)"Facing South", (robot.direction() != South ? 1 : 0) != 0);
    }

    public final void assertFacingWest(UrRobot robot) {
        KJRTest.assertTrue((String)"Not facing West", (robot.direction() == West ? 1 : 0) != 0);
    }

    public final void assertNotFacingWest(UrRobot robot) {
        KJRTest.assertTrue((String)"Facing West", (robot.direction() != West ? 1 : 0) != 0);
    }

    public final void assertAt(UrRobot robot, int street, int avenue) {
        this.assertOnStreet(robot, street);
        this.assertOnAvenue(robot, avenue);
    }

    public final void assertNotAt(UrRobot robot, int street, int avenue) {
        KJRTest.assertTrue((String)("At " + street + " street and " + avenue + " avenue."), (robot.street() != street || robot.avenue() != avenue ? 1 : 0) != 0);
    }

    public final void assertOnStreet(UrRobot robot, int street) {
        KJRTest.assertTrue((String)("Not on " + street + " street."), (robot.street() == street ? 1 : 0) != 0);
    }

    public final void assertNotOnStreet(UrRobot robot, int street) {
        KJRTest.assertTrue((String)("On " + street + " street."), (robot.street() != street ? 1 : 0) != 0);
    }

    public final void assertOnAvenue(UrRobot robot, int avenue) {
        KJRTest.assertTrue((String)("Not on " + avenue + " avenue."), (robot.avenue() == avenue ? 1 : 0) != 0);
    }

    public final void assertNotOnAvenue(UrRobot robot, int avenue) {
        KJRTest.assertTrue((String)("On " + avenue + " avenue."), (robot.avenue() != avenue ? 1 : 0) != 0);
    }

    public final void assertHasNeighbor(UrRobot robot) {
        KJRTest.assertTrue((String)"No neighbors present.", (boolean)World.checkRobot(robot, robot.street(), robot.avenue()));
    }

    public final void assertHasNoNeighbor(UrRobot robot) {
        KJRTest.assertTrue((String)"Neighbors present.", (!World.checkRobot(robot, robot.street(), robot.avenue()) ? 1 : 0) != 0);
    }

    public final void assertNextToABeeper(UrRobot robot) {
        KJRTest.assertTrue((String)"Not next to a beeper.", (boolean)World.checkBeeper(robot.street(), robot.avenue()));
    }

    public final void assertNotNextToABeeper(UrRobot robot) {
        KJRTest.assertTrue((String)"Next to a beeper.", (!World.checkBeeper(robot.street(), robot.avenue()) ? 1 : 0) != 0);
    }

    public final void assertBeepersInBeeperBag(UrRobot robot) {
        KJRTest.assertTrue((String)"No beepers in bag.", (robot.beepers() > 0 || robot.beepers() == -1 ? 1 : 0) != 0);
    }

    public final void assertNoBeepersInBeeperBag(UrRobot robot) {
        KJRTest.assertTrue((String)"Beepers in bag.", (robot.beepers() == 0 ? 1 : 0) != 0);
    }

    public final void assertFrontIsClear(UrRobot robot) {
        KJRTest.assertTrue((String)"Front is blocked.", (boolean)this.frontIsClear(robot));
    }

    public final void assertFrontIsBlocked(UrRobot robot) {
        KJRTest.assertTrue((String)"Front is clear.", (!this.frontIsClear(robot) ? 1 : 0) != 0);
    }

    public final void assertRunning(UrRobot robot) {
        KJRTest.assertTrue((String)"Not running.", (boolean)robot.running());
    }

    public final void assertNotRunning(UrRobot robot) {
        KJRTest.assertTrue((String)"Still running.", (!robot.running() ? 1 : 0) != 0);
    }

    public final void assertBeepersInWorld(int n) {
        int totalBeepers = this.totalBeepers();
        KJRTest.assertEquals((String)"Wrong number of beepers in world.", (int)n, (int)totalBeepers);
    }

    public final void assertBeepersInWorld() {
        int totalBeepers = this.totalBeepers();
        KJRTest.assertTrue((String)"No beepers in world.", (totalBeepers > 0 ? 1 : 0) != 0);
    }

    private int totalBeepers() {
        int totalBeepers = 0;
        Enumeration allBeepers = World.beepers();
        while (allBeepers.hasMoreElements()) {
            totalBeepers += ((World.BeeperCell)allBeepers.nextElement()).number();
        }
        return totalBeepers;
    }

    private int totalBeepers(int street, int avenue) {
        int totalBeepers = 0;
        Enumeration allBeepers = World.beepers();
        while (allBeepers.hasMoreElements()) {
            World.BeeperCell cell = (World.BeeperCell)allBeepers.nextElement();
            if (street != cell.street() || avenue != cell.avenue()) continue;
            totalBeepers = cell.number();
            break;
        }
        return totalBeepers;
    }

    public final void assertRobotsInWorld(int n) {
        KJRTest.assertEquals((String)"Wrong number of robots in world.", (int)n, (int)World.numberOfRobots());
    }

    public final void assertRobotsInWorld() {
        KJRTest.assertTrue((String)"No robots in world.", (World.numberOfRobots() > 0 ? 1 : 0) != 0);
    }

    public final void assertBeepersAt(int street, int avenue, int n) {
        KJRTest.assertEquals((String)"Wrong number of beepers on corner.", (int)n, (int)this.totalBeepers(street, avenue));
    }

    public final void assertBeepersAt(int street, int avenue) {
        KJRTest.assertTrue((String)"No beepers on corner.", (this.totalBeepers(street, avenue) > 0 ? 1 : 0) != 0);
    }

    private final int robotsOnCorner(int street, int avenue) {
        int totalRobots = 0;
        Enumeration robots = World.robots();
        while (robots.hasMoreElements()) {
            UrRobot karel = (UrRobot)robots.nextElement();
            if (!karel.areYouHere(street, avenue)) continue;
            ++totalRobots;
        }
        return totalRobots;
    }

    public final void assertRobotsAt(int street, int avenue, int n) {
        KJRTest.assertEquals((String)"Wrong number of robots on corner.", (int)n, (int)this.robotsOnCorner(street, avenue));
    }

    public final void assertRobotsAt(int street, int avenue) {
        KJRTest.assertTrue((String)"No robots on corner.", (this.robotsOnCorner(street, avenue) > 0 ? 1 : 0) != 0);
    }
}

