/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import kareltherobot.Directions;
import kareltherobot.RobotWorldWindow;
import kareltherobot.World;
import kareltherobot.WorldBuilder;
import kareltherobot.WorldBuilderInterface;

public class MiniBuilder
extends Frame
implements Directions,
WorldBuilderInterface {
    private TextField streets = new TextField(5);
    private TextField avenues = new TextField(5);
    private Button horizontalWall = new Button("Horizontal Wall");
    private Button verticalWall = new Button("Vertical Wall");
    private Button beeper = new Button("Beeper");
    private Button selectedButton = null;
    private Button showSpeed = new Button("Hide Speedcontrol");
    private boolean isDirty = false;
    private Color buttonColor = null;
    private Color selectedColor = new Color(192, 255, 192);
    private Label statusBar = new Label("");
    private Label whereBar = new Label("");
    private Button clearAll = new Button("Clear World");
    private ItemDropper itemDropper = new ItemDropper();
    private RobotWorldWindow view = World.view();
    private Font displayFont = new Font("Dialog", 0, 14);
    private BeeperScaler beeperScaler = new BeeperScaler();
    private HorizontalWallScaler horizontalWallScaler = new HorizontalWallScaler();
    private VerticalWallScaler verticalWallScaler = new VerticalWallScaler();
    private MouseWatcher mouseWatcher = new MouseWatcher();
    private static final int fromTop = 10;
    static WorldBuilder wb = null;

    public void cleanUp() {
    }

    public MiniBuilder(boolean showSpeedControl) {
        super("World Builder");
        if (!showSpeedControl) {
            this.showSpeed.setLabel("Show Speedcontrol");
        }
        this.setSize(120, 380);
        this.setLocation(560, 30);
        Panel toolPanel = new Panel(new GridLayout(3, 1, 0, 20));
        this.add("Center", toolPanel);
        this.showSpeed.addActionListener(new SpeedListener());
        Panel spacerPanel = new Panel(new GridLayout(2, 1, 0, 5));
        Panel sizePanel = new Panel(new GridLayout(2, 2, 0, 5));
        Label filler1 = new Label();
        filler1.setVisible(false);
        Label filler2 = new Label();
        filler2.setVisible(false);
        Panel innerSpacerPanel = new Panel(new GridLayout(2, 1, 0, 5));
        innerSpacerPanel.add(new Label("Controller"));
        innerSpacerPanel.add(this.showSpeed);
        spacerPanel.add(innerSpacerPanel);
        spacerPanel.add(sizePanel);
        toolPanel.add("North", spacerPanel);
        this.streets.setFont(this.displayFont);
        this.avenues.setFont(this.displayFont);
        sizePanel.add(this.streets);
        sizePanel.add(new Label("Streets"));
        sizePanel.add(this.avenues);
        sizePanel.add(new Label("Avenues"));
        Panel buttonPanel = new Panel(new GridLayout(5, 1, 0, 5));
        toolPanel.add("Center", buttonPanel);
        this.whereBar.setAlignment(1);
        this.statusBar.setAlignment(1);
        this.whereBar.setFont(this.displayFont);
        this.statusBar.setFont(this.displayFont);
        buttonPanel.add(this.statusBar);
        buttonPanel.add(this.whereBar);
        buttonPanel.add(this.horizontalWall);
        buttonPanel.add(this.verticalWall);
        buttonPanel.add(this.beeper);
        Panel savePanel = new Panel(new GridLayout(5, 1, 0, 5));
        toolPanel.add("South", savePanel);
        savePanel.add(this.clearAll);
        this.streets.addActionListener(new RowListener());
        this.avenues.addActionListener(new ColumnListener());
        this.horizontalWall.addActionListener(new HorizontalListener());
        this.verticalWall.addActionListener(new VerticalListener());
        this.beeper.addActionListener(new BeeperListener());
        this.clearAll.addActionListener(new ClearListener());
        this.buttonColor = this.beeper.getBackground();
        this.view.addMouseListener(this.itemDropper);
        this.streets.setText("" + World.numberOfStreets());
        this.avenues.setText("" + World.numberOfAvenues());
        this.view.attachMouseMotionListener(this.mouseWatcher);
        if (!showSpeedControl) {
            this.view.showControlDialog(false);
        }
        this.pack();
        this.setVisible(true);
        World.registerBuilder(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MiniBuilder.this.setVisible(false);
            }
        });
    }

    public void updateStreetsAvenues(int streets, int avenues) {
        this.streets.setText("" + streets);
        this.avenues.setText("" + avenues);
    }

    public static void main(String[] args) {
        wb = new WorldBuilder(false);
    }

    private class ClearListener
    implements ActionListener {
        ClearListener() {
        }

        public void actionPerformed(ActionEvent e) {
            World.reset();
            MiniBuilder.this.isDirty = true;
            MiniBuilder.this.streets.setText("" + World.numberOfStreets());
            MiniBuilder.this.avenues.setText("" + World.numberOfAvenues());
            MiniBuilder.this.repaint();
            MiniBuilder.this.view.repaint();
        }
    }

    private class HorizontalListener
    implements ActionListener {
        HorizontalListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Button thisButton = (Button)e.getSource();
            if (thisButton != MiniBuilder.this.selectedButton) {
                ((Button)e.getSource()).setBackground(MiniBuilder.this.selectedColor);
                MiniBuilder.this.beeper.setBackground(Color.lightGray);
                MiniBuilder.this.verticalWall.setBackground(Color.lightGray);
                MiniBuilder.this.selectedButton = thisButton;
                MiniBuilder.this.statusBar.setText("Horizontal Wall");
                MiniBuilder.this.mouseWatcher.setScaler(MiniBuilder.this.horizontalWallScaler);
                MiniBuilder.this.itemDropper.setScaler(MiniBuilder.this.horizontalWallScaler);
                MiniBuilder.this.view.ewCursor();
            } else {
                thisButton.setBackground(Color.lightGray);
                MiniBuilder.this.selectedButton = null;
                MiniBuilder.this.statusBar.setText("");
                MiniBuilder.this.whereBar.setText("");
                MiniBuilder.this.mouseWatcher.setScaler(null);
                MiniBuilder.this.itemDropper.setScaler(null);
                MiniBuilder.this.view.defaultCursor();
            }
        }
    }

    private class VerticalListener
    implements ActionListener {
        VerticalListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Button thisButton = (Button)e.getSource();
            if (thisButton != MiniBuilder.this.selectedButton) {
                ((Button)e.getSource()).setBackground(MiniBuilder.this.selectedColor);
                MiniBuilder.this.beeper.setBackground(Color.lightGray);
                MiniBuilder.this.horizontalWall.setBackground(Color.lightGray);
                MiniBuilder.this.selectedButton = thisButton;
                MiniBuilder.this.statusBar.setText("Vertical Wall");
                MiniBuilder.this.mouseWatcher.setScaler(MiniBuilder.this.verticalWallScaler);
                MiniBuilder.this.itemDropper.setScaler(MiniBuilder.this.verticalWallScaler);
                MiniBuilder.this.view.nsCursor();
            } else {
                thisButton.setBackground(Color.lightGray);
                MiniBuilder.this.selectedButton = null;
                MiniBuilder.this.statusBar.setText("");
                MiniBuilder.this.whereBar.setText("");
                MiniBuilder.this.mouseWatcher.setScaler(null);
                MiniBuilder.this.itemDropper.setScaler(null);
                MiniBuilder.this.view.defaultCursor();
            }
        }
    }

    private class BeeperListener
    implements ActionListener {
        BeeperListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Button thisButton = (Button)e.getSource();
            if (thisButton != MiniBuilder.this.selectedButton) {
                ((Button)e.getSource()).setBackground(MiniBuilder.this.selectedColor);
                MiniBuilder.this.horizontalWall.setBackground(Color.lightGray);
                MiniBuilder.this.verticalWall.setBackground(Color.lightGray);
                MiniBuilder.this.selectedButton = thisButton;
                MiniBuilder.this.statusBar.setText("Beeper");
                MiniBuilder.this.mouseWatcher.setScaler(MiniBuilder.this.beeperScaler);
                MiniBuilder.this.itemDropper.setScaler(MiniBuilder.this.beeperScaler);
                MiniBuilder.this.view.beeperCursor();
            } else {
                thisButton.setBackground(Color.lightGray);
                MiniBuilder.this.selectedButton = null;
                MiniBuilder.this.statusBar.setText("");
                MiniBuilder.this.whereBar.setText("");
                MiniBuilder.this.mouseWatcher.setScaler(null);
                MiniBuilder.this.itemDropper.setScaler(null);
                MiniBuilder.this.view.defaultCursor();
            }
        }
    }

    private class RowListener
    implements ActionListener {
        RowListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                World.setSize(Integer.parseInt(MiniBuilder.this.streets.getText()), World.numberOfAvenues());
                MiniBuilder.this.view.setVisible(false);
                MiniBuilder.this.view.repaint();
                MiniBuilder.this.view.setVisible(true);
                MiniBuilder.this.isDirty = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class ColumnListener
    implements ActionListener {
        ColumnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                World.setSize(World.numberOfStreets(), Integer.parseInt(MiniBuilder.this.avenues.getText()));
                MiniBuilder.this.view.setVisible(false);
                MiniBuilder.this.view.repaint();
                MiniBuilder.this.view.setVisible(true);
                MiniBuilder.this.isDirty = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class SpeedListener
    implements ActionListener {
        SpeedListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().indexOf("Show") > -1) {
                MiniBuilder.this.showSpeed.setLabel("Hide Speedcontrol");
                MiniBuilder.this.view.showControlDialog(true);
            } else {
                MiniBuilder.this.showSpeed.setLabel("Show Speedcontrol");
                MiniBuilder.this.view.showControlDialog(false);
            }
        }
    }

    static interface MouseScaler {
        public void scale(int var1, int var2, Point var3);

        public void dropItem(MouseEvent var1);
    }

    private class BeeperScaler
    implements MouseScaler {
        private Point where = new Point();

        BeeperScaler() {
        }

        public void scale(int rawx, int rawy, Point result) {
            int scale = (MiniBuilder.this.view.bottom() - 10) / World.numberOfStreets();
            if (scale == 0) {
                scale = 1;
            }
            result.x = (rawx - MiniBuilder.this.view.left() + scale / 2) / scale;
            result.y = (MiniBuilder.this.view.bottom() - rawy + scale / 2) / scale;
        }

        public void dropItem(MouseEvent evt) {
            boolean add;
            this.scale(evt.getX(), evt.getY(), this.where);
            int street = this.where.y;
            int avenue = this.where.x;
            if (street < 1 || avenue < 1 || street > World.numberOfStreets() || avenue > World.numberOfAvenues()) {
                return;
            }
            int keyMask = 2;
            if (System.getProperty("os.name").indexOf("Mac") > -1) {
                keyMask = 8;
            }
            boolean bl = add = (evt.getModifiers() & keyMask) == 0;
            if ((evt.getModifiers() & 1) != 0) {
                World.clearBeepers(street, avenue);
            } else {
                World.placeBeepers(street, avenue, add ? 1 : -1);
            }
            MiniBuilder.this.view.setVisible(true);
        }
    }

    private class HorizontalWallScaler
    implements MouseScaler {
        private Point where = new Point();

        HorizontalWallScaler() {
        }

        public void scale(int rawx, int rawy, Point result) {
            int scale = (MiniBuilder.this.view.bottom() - 10) / World.numberOfStreets();
            if (scale == 0) {
                scale = 1;
            }
            result.x = (rawx - MiniBuilder.this.view.left() + scale / 2) / scale;
            result.y = (MiniBuilder.this.view.bottom() - rawy) / scale;
        }

        public void dropItem(MouseEvent evt) {
            boolean add;
            this.scale(evt.getX(), evt.getY(), this.where);
            int street = this.where.y;
            int avenue = this.where.x;
            if (street < 1 || avenue < 1 || street > World.numberOfStreets() - 1 || avenue > World.numberOfAvenues()) {
                return;
            }
            int keyMask = 2;
            if (System.getProperty("os.name").indexOf("Mac") > -1) {
                keyMask = 8;
            }
            boolean bl = add = (evt.getModifiers() & keyMask) == 0;
            if (add) {
                World.placeEWWall(street, avenue, 1);
            } else {
                World.removeEWWall(street, avenue);
            }
            MiniBuilder.this.view.setVisible(true);
        }
    }

    private class VerticalWallScaler
    implements MouseScaler {
        private Point where = new Point();

        VerticalWallScaler() {
        }

        public void scale(int rawx, int rawy, Point result) {
            int scale = (MiniBuilder.this.view.bottom() - 10) / World.numberOfStreets();
            if (scale == 0) {
                scale = 1;
            }
            result.x = (rawx - MiniBuilder.this.view.left()) / scale;
            result.y = (MiniBuilder.this.view.bottom() - rawy + scale / 2) / scale;
        }

        public void dropItem(MouseEvent evt) {
            boolean add;
            this.scale(evt.getX(), evt.getY(), this.where);
            int street = this.where.y;
            int avenue = this.where.x;
            if (street < 1 || avenue < 1 || street > World.numberOfStreets() || avenue > World.numberOfAvenues() - 1) {
                return;
            }
            int keyMask = 2;
            if (System.getProperty("os.name").indexOf("Mac") > -1) {
                keyMask = 8;
            }
            boolean bl = add = (evt.getModifiers() & keyMask) == 0;
            if (add) {
                World.placeNSWall(street, avenue, 1);
            } else {
                World.removeNSWall(street, avenue);
            }
            MiniBuilder.this.view.setVisible(true);
        }
    }

    private class MouseWatcher
    extends MouseMotionAdapter {
        private MouseScaler scaler = null;
        private Point where = new Point();

        MouseWatcher() {
        }

        public void mouseMoved(MouseEvent evt) {
            if (this.scaler != null) {
                this.scaler.scale(evt.getX(), evt.getY(), this.where);
                int avenue = this.where.x;
                int street = this.where.y;
                if (avenue < 1) {
                    avenue = 1;
                }
                if (street < 1) {
                    street = 1;
                }
                MiniBuilder.this.whereBar.setText(street + ", " + avenue);
                MiniBuilder.this.repaint();
            }
        }

        public void setScaler(MouseScaler scaler) {
            this.scaler = scaler;
        }
    }

    private class ItemDropper
    extends MouseAdapter {
        private MouseScaler scaler = null;

        ItemDropper() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.scaler != null) {
                this.scaler.dropItem(evt);
                MiniBuilder.this.view.repaint();
                MiniBuilder.this.isDirty = true;
            }
        }

        public void setScaler(MouseScaler scaler) {
            this.scaler = scaler;
        }
    }
}

