/*
 * Decompiled with CFR 0.152.
 */
package kareltherobot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import kareltherobot.RobotTask;
import kareltherobot.World;
import kareltherobot.WorldBuilder;

public class KarelRunner {
    private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    private static boolean clearing = true;
    private static String filename = "";

    public static void main(String[] args) {
        String className = null;
        String worldOption = "";
        if (args.length < 1) {
            className = KarelRunner.getName();
        } else {
            className = args[0];
            int i = 1;
            while (i < args.length) {
                if ((args[i].charAt(0) == '/' || args[i].charAt(0) == '-') && args[i].length() > 1) {
                    switch (Character.toUpperCase(args[i].charAt(1))) {
                        case 'B': {
                            worldOption = "b";
                            break;
                        }
                        case 'W': {
                            if (args.length > i + 1) {
                                filename = args[i + 1];
                                ++i;
                                break;
                            }
                            System.out.println("No world filename");
                            System.exit(1);
                            break;
                        }
                        default: {
                            System.out.println("Invalid option " + args[i] + ": Only BW allowed\n");
                            System.exit(1);
                        }
                    }
                }
                ++i;
            }
        }
        try {
            if (worldOption.equalsIgnoreCase("b")) {
                WorldBuilder i = new WorldBuilder(true);
            }
            Class<?> robotClass = Class.forName(className);
            RobotTask robotInstance = (RobotTask)robotClass.newInstance();
            String answer = KarelRunner.prompt();
            while (KarelRunner.ok(answer)) {
                if (clearing) {
                    World.reset();
                }
                if (filename != null && filename != "") {
                    World.readWorld(filename);
                }
                World.setVisible(true);
                robotInstance.task();
                answer = KarelRunner.prompt();
            }
            System.exit(0);
        }
        catch (ClassCastException classcast) {
            System.out.println("Your class does not implement RobotTester.");
            System.exit(3);
        }
        catch (ClassNotFoundException noClass) {
            System.out.println("No such class.");
            System.exit(2);
        }
        catch (IllegalAccessException illegalClass) {
            System.out.println("Can't access that class.");
            System.exit(4);
        }
        catch (InstantiationException illegalClass) {
            System.out.println("Can't instantiate that class.");
            System.exit(5);
        }
        catch (Throwable other) {
            System.out.println("Unexplained Error.");
            System.exit(6);
        }
    }

    private static String getName() {
        String result = null;
        System.out.print("Name of class to test: ");
        try {
            result = in.readLine();
        }
        catch (IOException e) {
            System.out.println("No such class");
            System.exit(1);
        }
        return result;
    }

    private static String getWorldBuilderOption() {
        String result = "x";
        System.out.print("Would you like the world builder? Y/n: ");
        try {
            result = in.readLine();
            if (KarelRunner.ok(result)) {
                return "b";
            }
        }
        catch (IOException e) {
            System.out.println("Error");
            System.exit(1);
        }
        return result;
    }

    private static boolean ok(String answer) {
        boolean worldfile;
        if (answer.length() > 0 && (answer.charAt(0) == 'n' || answer.charAt(0) == 'N')) {
            return false;
        }
        clearing = answer.length() > 0 && (answer.charAt(0) == 'c' || answer.charAt(0) == 'C');
        boolean bl = worldfile = answer.length() > 0 && (answer.charAt(0) == 'w' || answer.charAt(0) == 'W');
        if (worldfile) {
            filename = answer.substring(1).trim();
        }
        return true;
    }

    private static String prompt() {
        System.out.print("Run robot task? Y/n/c/w ");
        String result = "no";
        try {
            try {
                result = in.readLine();
                if (result == null) {
                    // empty if block
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        return result.trim();
    }
}

