/*
 * Decompiled with CFR 0.152.
 */
package com.mathorama.joust;

import com.mathorama.joust.Board;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Joust
extends JPanel
implements MouseMotionListener,
MouseListener {
    private Board board = new Board(8, 8, 50, 50);
    private Rectangle restartBtn = new Rectangle(700, 350, 100, 35);
    private Font font;
    private Font smFont;
    private String message;
    private static int WIDE = 950;
    private static int TALL = 680;

    public Joust() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.font = new Font("SansSerif", 0, 24);
        this.smFont = new Font("SansSerif", 0, 18);
        this.message = "Joust! White's move";
    }

    public static void main(String[] args) {
        Joust app = new Joust();
        JFrame window = new JFrame("Joust");
        window.setSize(WIDE, TALL);
        window.setDefaultCloseOperation(3);
        window.getContentPane().add(app);
        window.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        g.setFont(this.smFont);
        g.drawString("Each square can only be visited", 650, TALL / 3);
        g.drawString("once.", 650, TALL / 3 + 20);
        g.drawString("Win by leaving your opponent", 650, TALL / 3 + 50);
        g.drawString("without any possible moves.", 650, TALL / 3 + 70);
        g.setColor(Color.BLUE);
        g.setFont(this.font);
        g.drawString(this.message, 650, 55);
        g.drawString(this.board.getMessage2(), 650, 85);
        g.drawString(this.board.getMessage1(), 650, 115);
        if (this.board.gameOver()) {
            g.setColor(Color.BLUE);
            g.fillRect(this.restartBtn.x, this.restartBtn.y, this.restartBtn.width, this.restartBtn.height);
            g.setColor(Color.YELLOW);
            g.drawString("Restart", this.restartBtn.x + 10, this.restartBtn.y + 25);
        }
        this.board.draw(g);
        this.drawLabels(g, this.board);
    }

    public void drawLabels(Graphics g, Board b) {
        int size = b.getSquareSize();
        int rows = b.getNumRows();
        int cols = b.getNumCols();
        int x = b.getLeft();
        int y = b.getTop();
        g.setFont(this.smFont);
        int i = 0;
        while (i < rows) {
            g.drawString("" + (8 - i), x - 20, 10 + y + i * size + size / 2);
            g.drawString("" + (8 - i), x + 8 * size + 10, 10 + y + i * size + size / 2);
            ++i;
        }
        i = 0;
        while (i < cols) {
            g.drawString("abcdefgh".substring(i, i + 1), x + i * size + size / 2, y - 9);
            g.drawString("abcdefgh".substring(i, i + 1), x + i * size + size / 2, y + cols * size + 18);
            ++i;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.board.move();
        if (this.board.gameOver() && this.restartBtn.contains(e.getPoint())) {
            this.board = new Board(8, 8, 50, 50);
            this.repaint();
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.board.setHighlight(x, y);
        this.message = this.board.whoseTurn();
        this.repaint();
    }
}

