/*
 * Decompiled with CFR 0.152.
 */
package com.mathorama.joust;

import com.mathorama.joust.Board;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class Knight {
    private int row = 0;
    private int col = 0;
    private Color color = Color.WHITE;
    public static final String KNIGHT_OUTLINE = "\u2658";
    public static final String KNIGHT = "\u265e";

    public Knight() {
    }

    public Knight(String color) {
        this();
        if (color.equals("black")) {
            this.color = Color.BLACK;
        }
    }

    public Knight(String color, int row, int col) {
        this(color);
        this.row = row;
        this.col = col;
    }

    public void draw(Graphics g, Board board) {
        int size = board.getSquareSize();
        int offset = (int)((double)size / 5.0);
        int x = board.getLeft() + this.col * size;
        int y = board.getTop() + this.row * size;
        Font font = new Font("Arial Unicode MS", 0, size);
        g.setFont(font);
        g.setColor(this.color);
        g.drawString(KNIGHT, x, y + size - offset);
        if (this.isWhite()) {
            g.setColor(Color.BLACK);
            g.drawString(KNIGHT_OUTLINE, x, y + size - offset);
        }
    }

    public boolean isWhite() {
        return this.color == Color.WHITE;
    }

    public boolean isBlack() {
        return !this.isWhite();
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

