package com.mathorama.joust;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Square {
    /**
     * constants
     */
    public static final int black=0;
    public static final int white=1;
    public static final int burned=2;
    /**
     * instance fields
     */

    private Color[] colors; 
    private int color;
    private boolean highlighted;
    private Rectangle box;
    /**
     * constructors 
     */
    public Square(){
    	colors = new Color[3];
    	colors[black] = new Color (208,145,145);
    	colors[white] = new Color(243, 219, 219);
    	colors[burned] = new Color(100, 0, 0);
        setColor(Square.white);
        setHighlighted(false);
        box=null;
    }

    public Square(int color) {
        this(); //use the default constructor to initialize
        this.setColor(color);
    }

    public Square(int color, Rectangle box) {
        this(); //use the default constructor to initialize
        this.setColor(color);
        this.box=box;
    }

    /**
     * Access Methods
     */
    public int getColor() {
        return color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    /**
     * other methods
     */
    public void draw(Graphics g){
        if (box==null)
            return;
        int w=2;//width of outline
        int x= (int)box.getX();
        int y= (int)box.getY();
        int size = (int)box.getHeight();
        if (highlighted){
            g.setColor(Color.MAGENTA);
        }else{
            g.setColor(Color.BLACK);
        }
        g.fillRect(x, y, size, size);

        g.setColor(colors[color]);
        g.fillRect(x+w, y+w, size-2*w, size-2*w);

    }
    public boolean isHighlighted() {
        return highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    /**
     * given screen location x,y sets the highlight on or off 
     * @param x screen coord
     * @param y screen coord
     * @return the Square if highlighted, otherwise null
     */
    public Square select(int x, int y){
        this.setHighlighted(box.contains(x,y));
        if(this.isHighlighted())
            return this;
        else
            return null;
    }

    public boolean isBurned(){
        return color == burned;

    }
}