package com.mathorama.joust;

import java.awt.Graphics;
import java.awt.Rectangle;

/**
 * A Joust game board... free to use for educational use
 * @author Chris Thiel, OFMCap
 * original date 30 Sept 2012
 * @version 9 April 2020
 */
public class Board {

	private int squareSize, top,left;
	private Square[][] grid;
	private Square selectedSquare; 
	private int selectedRow, selectedCol;
	private Knight[] player;
	private Knight currentPlayer;
	private String message1, message2;

	public Board(int rows, int cols, int top, int left) 
	{
		this.setSquareSize(70);
		grid=new Square[rows][cols];
		setTop(top);
		setLeft(left);
		setSelectedSquare(null);
		setSelectedRow(-1);
		setSelectedCol(-1);
		setMessage1("White's turn");
		setMessage2("Joust");
		for (int r=0; r<getNumRows();r++)
			for (int c=0; c< getNumCols();c++){
				int color=(r+c+1)%2;//alternate color
				int x=left + c*squareSize;
				int y=top + r*squareSize;
				Rectangle rectangle=new Rectangle(x,y,squareSize,squareSize);
				grid[r][c]=new Square(color, rectangle);
			}
		player = new Knight[2];
		int rand=(int)(getNumCols()*Math.random());
		player[0]=new Knight("white", getNumRows()-1,rand);
		rand=(int)(getNumCols()*Math.random());
		player[1]=new Knight("black",0,rand);

		setCurrentPlayer(player[0]);

	}

	/**
	 * access methods
	 * 
	 */
	public int getNumRows(){
		return grid.length;
	}

	public int getNumCols(){
		return grid[0].length;
	}

	public Square getSquare(int row, int col){
		return grid[row][col];
	}

	public int getTop() {
		return top;
	}

	public void setTop(int top) {
		this.top = top;
	}

	public int getLeft() {
		return left;
	}

	public void setLeft(int left) {
		this.left = left;
	}

	public int getSquareSize() {
		return squareSize;
	}

	public void setSquareSize(int squareSize) {
		this.squareSize = squareSize;
	}

	public Knight getCurrentPlayer() {
		return currentPlayer;
	}

	/**
	 * Check if the square at r,c is burned
	 * or occupied by one of the players
	 * @param r
	 * @param c
	 * @return is the square is availible
	 */
	public boolean isAvailable(int r, int c){
		if (r<0 || c<0 || r>=getNumRows() || c>=getNumCols())
			return false;
		if (grid[r][c].isBurned())
			return false;
		for(int i=0;i<2;i++)
			if (player[i].getRow()==r && player[i].getCol()==c)
				return false;
		return true;
	}

	public void setCurrentPlayer(Knight currentPlayer) {
		this.currentPlayer = currentPlayer;
	}

	public String getMessage1() {
		return message1;
	}public String getMessage2() {
		return message2;
	}

	public void setMessage1(String message) {
		this.message1 = message;
	}
	public void setMessage2(String message) {
		this.message2 = message;
	}

	public Square getSelectedSquare() {
		return selectedSquare;
	}

	public void setSelectedSquare(Square selectedSquare) {
		this.selectedSquare = selectedSquare;
	}

	public int getSelectedRow() {
		return selectedRow;
	}

	public void setSelectedRow(int selectedRow) {
		this.selectedRow = selectedRow;
	}

	public int getSelectedCol() {
		return selectedCol;
	}

	public void setSelectedCol(int selectedCol) {
		this.selectedCol = selectedCol;
	}

	/**
	 * other methods
	 */
	public void draw(Graphics g){
		for (int r=0; r<getNumRows();r++)
			for (int c=0; c< getNumCols();c++){
				grid[r][c].draw(g);
			}
		player[0].draw(g, this);
		player[1].draw(g, this);

	}

	public void setHighlight(int x, int y){

		for (int r=0; r<getNumRows();r++)
			for (int c=0; c< getNumCols();c++){
				Square s=grid[r][c].select(x, y);
				if (s!=null) {
					setSelectedSquare(s);
					setSelectedRow(r);
					setSelectedCol(c);
				}
			}
		message1 = getAlgebraicNotation(currentPlayer.getRow(), currentPlayer.getCol());
		message2 = "(" + currentPlayer.getRow() + ", " + currentPlayer.getCol() +") " ;
		if (selectedRow <0 || selectedCol < 0 || selectedRow > grid.length-1 || selectedCol > grid[0].length-1)
			return;
		message1 += " to " + getAlgebraicNotation(selectedRow,selectedCol)+" is ";
		message2 += " to (" + selectedRow+", "+selectedCol+") ";
		if (isLegalMove(currentPlayer, selectedRow,selectedCol))
			message1+="legal";
		else 
			message1+="NOT legal";

	}

	public String getSelected(){
		return "(" + selectedRow + ", " + selectedCol + ")";
	}
	/**
	 * Convert the row, col (Where black rook is row 0, col 0) 
	 * to Algebraic Chess notation
	 * @param row 
	 * @param col
	 * @return Algebraic Chess notation
	 */
	public String getAlgebraicNotation(int row, int col) {
		//your code here
		return "abcdefgh".charAt(col) + "" + (8-row);
	}

	public String whoseTurn(){

		if (! gameOver() && currentPlayer.isWhite())
			return "White's turn";
		if (! gameOver() && currentPlayer.isBlack())
			return "Black's turn";
		if (hasMovesLeft(player[0]))
			return "White wins";
		return "Black Wins";
	}

	public void move(){

		if(gameOver())
			return;
		if (isLegalMove(currentPlayer, selectedRow, selectedCol)){
			grid[currentPlayer.getRow()][currentPlayer.getCol()].setColor(Square.burned);
			currentPlayer.setRow(selectedRow);
			currentPlayer.setCol(selectedCol);	

			if (!gameOver() ){
				if (currentPlayer==player[0])
					currentPlayer=player[1];
				else
					currentPlayer=player[0];

			}
		}	
		message1=whoseTurn();
	}

	/**
	 * Checks if both players have any 
	 * availible Moves left 
	 * @return whether the game is over
	 */
	public boolean gameOver(){
		for (int i=0;i<2;i++)
			if (!hasMovesLeft(player[i]))
				return true;
		return false;
	}

	/**
	 * Using a series of conditional statements
	 * checks to see if the square at r,c 
	 * is a valid place to move this knight
	 * 
	 * The square r,c must be a location that:
	 *  (1) a knight can legally move to,  
	 *  (2) cannot already be occupied by the other player,
	 *  (3) has not been burned (already been visited).
	 * 
	 * @param board
	 * @param r the row in question
	 * @param c the column in question
	 * @return whether the knight can validly go to the square 
	 */
	public boolean isLegalMove(Knight player, int r, int c) {
		//your code here 
		
		return false;
	}
	/**
	 * hasMovesLeft determines if any moves are possible
	 * avoid duplication of code by using other methods wisely.
	 *  
	 * @param player
	 * @return whether the player has a legal move left
	 */
	public boolean hasMovesLeft(Knight player){
		// your code here

		
		return true;
	}
}