/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HangmanGUI
extends JPanel
implements KeyListener {
    public static int WIDTH = 800;
    public static int HEIGHT = 600;
    private Font titleFont = new Font("Times", 1, 18);
    private Font regularFont = new Font("Helvetica", 0, 12);
    private Font largeFont = new Font("Times", 1, 60);
    private Font giantFont = new Font("Times", 1, 80);
    private Polygon[] gallows = new Polygon[7];
    private HangmanPuzzle puzzle;
    private String message = "Type a letter";
    public static final int MAX_GUESSES = 6;
    private int wins;
    private int losses;

    public HangmanGUI() {
        this.gallows[0] = this.makeScaffold(52, 100, 12);
        this.gallows[1] = this.makeHead(130, 150, 35);
        this.gallows[2] = this.makeBody(155, 220, 5);
        this.gallows[3] = this.makeArmDown(130, 240, 5);
        this.gallows[4] = this.makeArmUp(200, 240, 5);
        this.gallows[5] = this.makeArmUp(130, 370, 5);
        this.gallows[6] = this.makeArmDown(200, 370, 5);
        this.puzzle = new HangmanPuzzle();
        this.wins = 0;
        this.losses = 0;
    }

    public static void main(String[] args) {
        HangmanGUI app = new HangmanGUI();
        JFrame window = new JFrame("Hangman");
        window.addKeyListener(app);
        window.setSize(WIDTH, HEIGHT);
        window.setDefaultCloseOperation(3);
        window.getContentPane().add(app);
        window.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLUE);
        g.setFont(this.titleFont);
        g.drawString("Hangman by Group X", 20, 20);
        g.setFont(this.regularFont);
        g.drawString("Version 1.0", 20, 40);
        if (this.puzzle.numberWrong() > 0) {
            g.setFont(this.titleFont);
            g.setColor(Color.RED);
            g.drawString("You have tried: ", 400, 75);
            g.setFont(this.largeFont);
            g.drawString(this.puzzle.getBadGuesses(), 400, 150);
        }
        g.setColor(Color.BLACK);
        g.setFont(this.titleFont);
        g.drawString("  Wins: " + this.wins, 500, 20);
        g.drawString("Losses: " + this.losses, 500, 50);
        g.setFont(this.titleFont);
        g.drawString(String.valueOf(6 - this.puzzle.numberWrong()) + " guesses remain", 300, 480);
        g.drawString(this.message, 300, 460);
        g.setFont(this.giantFont);
        g.setColor(Color.BLACK);
        g.drawString(this.puzzle.clue(), 300, 400);
        g.setColor(Color.BLUE);
        int parts = Math.min(6, this.puzzle.numberWrong());
        int i = 0;
        while (i < 1 + parts) {
            g.fillPolygon(this.gallows[i]);
            ++i;
        }
    }

    public Polygon makeScaffold(int x, int y, int scale) {
        Polygon result = new Polygon();
        result.addPoint(scale * 0, scale * 0);
        result.addPoint(scale * 15, scale * 0);
        result.addPoint(scale * 15, scale * 2);
        result.addPoint(scale * 10, scale * 2);
        result.addPoint(scale * 10, scale * 7);
        result.addPoint(scale * 9, scale * 7);
        result.addPoint(scale * 9, scale * 2);
        result.addPoint(scale * 2, scale * 2);
        result.addPoint(scale * 2, scale * 30);
        result.addPoint(scale * 0, scale * 30);
        result.translate(x, y);
        return result;
    }

    public Polygon makeHead(int x, int y, int scale) {
        Polygon result = new Polygon();
        double angle = 0.3490658503988659;
        int i = 0;
        while (i < 18) {
            int x0 = (int)((long)scale + Math.round((double)scale * Math.cos(angle * (double)i)));
            int y0 = (int)((long)scale + Math.round((double)scale * Math.sin(angle * (double)i)));
            result.addPoint(x0, y0);
            ++i;
        }
        result.translate(x, y);
        return result;
    }

    public Polygon makeArmDown(int x, int y, int scale) {
        Polygon result = new Polygon();
        result.addPoint(scale * -5, scale * -5);
        result.addPoint(scale * 5, scale * 5);
        result.addPoint(scale * 5, scale * 1);
        result.addPoint(scale * -5, scale * -9);
        result.translate(x, y);
        return result;
    }

    public Polygon makeArmUp(int x, int y, int scale) {
        Polygon result = new Polygon();
        result.addPoint(scale * -5, scale * 5);
        result.addPoint(scale * 5, scale * -5);
        result.addPoint(scale * 5, scale * -9);
        result.addPoint(scale * -5, scale * 1);
        result.translate(x, y);
        return result;
    }

    public Polygon makeBody(int x, int y, int scale) {
        Polygon result = new Polygon();
        result.addPoint(scale * 0, scale * 0);
        result.addPoint(scale * 0, scale * 25);
        result.addPoint(scale * 4, scale * 25);
        result.addPoint(scale * 4, scale * 0);
        result.translate(x, y);
        return result;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        String letter = "" + e.getKeyChar();
        if (this.puzzle.numberWrong() < 6) {
            this.puzzle.checkGuess(letter);
            this.message = "You guessed " + letter;
        }
        if (this.puzzle.numberWrong() >= 6) {
            this.message = "Sorry - Try again- the word was " + this.puzzle.getAnswer();
            this.puzzle = new HangmanPuzzle();
            ++this.losses;
        }
        if (this.puzzle.hasWon()) {
            this.message = "You won! the word was indeed " + this.puzzle.getAnswer() + "- try again";
            this.puzzle = new HangmanPuzzle();
            ++this.wins;
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

