/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Grid
extends JComponent
implements KeyListener,
MouseListener {
    private Cell[][] cells;
    private JFrame frame;
    private int lastKeyPressed;
    private Location lastLocationClicked;
    private Color lineColor;

    public Grid(int numRows, int numCols) {
        this.init(numRows, numCols);
    }

    public Grid(String imageFileName) {
        BufferedImage image = this.loadImage(imageFileName);
        this.init(image.getHeight(), image.getWidth());
        this.showImage(image);
        this.setTitle(imageFileName);
    }

    private BufferedImage loadImage(String imageFileName) {
        URL url = this.getClass().getResource(imageFileName);
        if (url == null) {
            throw new RuntimeException("cannot find file:  " + imageFileName);
        }
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to read from file:  " + imageFileName);
        }
    }

    public int getNumRows() {
        return this.cells.length;
    }

    public int getNumCols() {
        return this.cells[0].length;
    }

    private void init(int numRows, int numCols) {
        this.lastKeyPressed = -1;
        this.lastLocationClicked = null;
        this.lineColor = null;
        this.cells = new Cell[numRows][numCols];
        int row = 0;
        while (row < numRows) {
            int col = 0;
            while (col < numCols) {
                this.cells[row][col] = new Cell();
                ++col;
            }
            ++row;
        }
        this.frame = new JFrame("Grid");
        this.frame.setDefaultCloseOperation(3);
        this.frame.addKeyListener(this);
        int cellSize = Math.max(Math.min(500 / this.getNumRows(), 500 / this.getNumCols()), 1);
        this.setPreferredSize(new Dimension(cellSize * numCols, cellSize * numRows));
        this.addMouseListener(this);
        this.frame.getContentPane().add(this);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void showImage(BufferedImage image) {
        int row = 0;
        while (row < this.getNumRows()) {
            int col = 0;
            while (col < this.getNumCols()) {
                int x = col * image.getWidth() / this.getNumCols();
                int y = row * image.getHeight() / this.getNumRows();
                int c = image.getRGB(x, y);
                int red = (c & 0xFF0000) >> 16;
                int green = (c & 0xFF00) >> 8;
                int blue = c & 0xFF;
                this.cells[row][col].setColor(new Color(red, green, blue));
                ++col;
            }
            ++row;
        }
        this.repaint();
    }

    private int getCellSize() {
        int cellWidth = this.getWidth() / this.getNumCols();
        int cellHeight = this.getHeight() / this.getNumRows();
        return Math.min(cellWidth, cellHeight);
    }

    public void keyPressed(KeyEvent e) {
        this.lastKeyPressed = e.getKeyCode();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int cellSize = this.getCellSize();
        int row = e.getY() / cellSize;
        if (row < 0 || row >= this.getNumRows()) {
            return;
        }
        int col = e.getX() / cellSize;
        if (col < 0 || col >= this.getNumCols()) {
            return;
        }
        this.lastLocationClicked = new Location(row, col);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private static java.awt.Color toJavaColor(Color color) {
        return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void paintComponent(Graphics g) {
        int row = 0;
        while (row < this.getNumRows()) {
            int col = 0;
            while (col < this.getNumCols()) {
                Location loc = new Location(row, col);
                Cell cell = this.cells[loc.getRow()][loc.getCol()];
                Color color = cell.getColor();
                g.setColor(Grid.toJavaColor(color));
                int cellSize = this.getCellSize();
                int x = col * cellSize;
                int y = row * cellSize;
                g.fillRect(x, y, cellSize, cellSize);
                String imageFileName = cell.getImageFileName();
                if (imageFileName != null) {
                    URL url = this.getClass().getResource(imageFileName);
                    if (url == null) {
                        System.out.println("File not found:  " + imageFileName);
                    } else {
                        int height;
                        Image image = new ImageIcon(url).getImage();
                        int width = image.getWidth(null);
                        if (width > (height = image.getHeight(null))) {
                            int drawHeight = cellSize * height / width;
                            g.drawImage(image, x, y + (cellSize - drawHeight) / 2, cellSize, drawHeight, null);
                        } else {
                            int drawWidth = cellSize * width / height;
                            g.drawImage(image, x + (cellSize - drawWidth) / 2, y, drawWidth, cellSize, null);
                        }
                    }
                }
                if (this.lineColor != null) {
                    g.setColor(Grid.toJavaColor(this.lineColor));
                    g.drawRect(x, y, cellSize, cellSize);
                }
                ++col;
            }
            ++row;
        }
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public boolean isValid(Location loc) {
        int row = loc.getRow();
        int col = loc.getCol();
        return row >= 0 && row < this.getNumRows() && col >= 0 && col < this.getNumCols();
    }

    public void setColor(Location loc, Color color) {
        if (!this.isValid(loc)) {
            throw new RuntimeException("cannot set color of invalid location " + loc + " to color " + color);
        }
        this.cells[loc.getRow()][loc.getCol()].setColor(color);
        this.repaint();
    }

    public Color getColor(Location loc) {
        if (!this.isValid(loc)) {
            throw new RuntimeException("cannot get color from invalid location " + loc);
        }
        return this.cells[loc.getRow()][loc.getCol()].getColor();
    }

    public void setImage(Location loc, String imageFileName) {
        if (!this.isValid(loc)) {
            throw new RuntimeException("cannot set image for invalid location " + loc + " to \"" + imageFileName + "\"");
        }
        this.cells[loc.getRow()][loc.getCol()].setImageFileName(imageFileName);
        this.repaint();
    }

    public String getImage(Location loc) {
        if (!this.isValid(loc)) {
            throw new RuntimeException("cannot get image for invalid location " + loc);
        }
        return this.cells[loc.getRow()][loc.getCol()].getImageFileName();
    }

    public static void pause(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int checkLastKeyPressed() {
        int key = this.lastKeyPressed;
        this.lastKeyPressed = -1;
        return key;
    }

    public Location checkLastLocationClicked() {
        Location loc = this.lastLocationClicked;
        this.lastLocationClicked = null;
        return loc;
    }

    public void load(String imageFileName) {
        this.showImage(this.loadImage(imageFileName));
        this.setTitle(imageFileName);
    }

    public void save(String imageFileName) {
        try {
            BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.paintComponent(bi.getGraphics());
            int index = imageFileName.lastIndexOf(46);
            if (index == -1) {
                throw new RuntimeException("invalid image file name:  " + imageFileName);
            }
            ImageIO.write((RenderedImage)bi, imageFileName.substring(index + 1), new File(imageFileName));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to save image to file:  " + imageFileName);
        }
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
        this.repaint();
    }

    public void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public String showInputDialog(String message) {
        return JOptionPane.showInputDialog(this, (Object)message);
    }
}

