/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MyGenericApplication
extends JPanel
implements KeyListener,
ActionListener {
    public static int WIDTH = 1000;
    public static int HEIGHT = 1000;
    private Font titleFont;
    private Font regularFont;
    Building b = new Building();
    Elevator el = new Elevator();
    String message = "test";
    private Font floorFont = new Font("Arial", 1, 50);
    private Font personFont = new Font("Arial", 0, 20);
    private Timer timer;
    private long timeElapsed;
    private int points;
    private boolean stopPlease;

    public MyGenericApplication() {
        this.titleFont = new Font("Roman", 1, 18);
        this.regularFont = new Font("Helvetica", 0, 12);
        this.timer = new Timer(1000, this);
        this.timer.start();
        this.timeElapsed = 0L;
        this.points = 0;
        this.stopPlease = false;
    }

    public static void main(String[] args) {
        MyGenericApplication app = new MyGenericApplication();
        JFrame window = new JFrame("My Generic Application");
        window.setSize(WIDTH, HEIGHT);
        window.setDefaultCloseOperation(3);
        window.getContentPane().add(app);
        window.addKeyListener(app);
        window.setVisible(true);
        window.setResizable(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.stopPlease) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, WIDTH, HEIGHT);
            g.setFont(new Font("Arial", 1, 69));
            g.setColor(Color.BLACK);
            g.drawString("Game Over, " + this.points + " points", 100, 250);
            return;
        }
        super.paintComponent(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLUE);
        g.setFont(this.titleFont);
        g.drawString("My Generic Application", 20, 20);
        g.setColor(Color.BLACK);
        g.drawString(this.message, 20, 100);
        g.setFont(this.regularFont);
        g.drawString("Version 1.0", 20, 40);
        g.drawString("" + this.points, 20, 120);
        this.drawBuilding(g);
        this.drawElevator(g);
    }

    public void drawBuilding(Graphics g) {
        ArrayList<Person> toRemove = new ArrayList<Person>();
        for (Floor a : this.b.getFloorList()) {
            for (Person p : a.getFloorPersonList()) {
                if (!p.bored()) continue;
                this.stopPlease = true;
            }
            a.removeAll(toRemove);
        }
        for (Floor f : this.b.getFloorList()) {
            g.setColor(f.getFloorColor());
            g.fillRect(200, 700 - 100 * f.getFloorNum(), 600, 100);
            g.setColor(Color.BLACK);
            g.setFont(this.floorFont);
            g.drawRect(200, 700 - 100 * f.getFloorNum(), 600, 100);
            g.drawRect(200, 700 - 100 * f.getFloorNum(), 450, 100);
            g.drawString("" + f.getFloorNum(), 200, 700 - 100 * f.getFloorNum() + 92);
            int i = 0;
            while (i < f.getFloorPersonList().size()) {
                Person p = f.getFloorPersonList().get(i);
                g.setFont(this.personFont);
                g.setColor(Color.BLACK);
                g.fillRect(200 + 50 * i, 700 - 100 * f.getFloorNum(), 50, 50);
                g.setColor(Color.WHITE);
                g.drawRect(200 + 50 * i, 700 - 100 * f.getFloorNum(), 50, 50);
                g.setColor(this.getDesiredColor(p, this.b));
                g.drawString("" + p.getDesiredFloor(), 200 + 50 * i + 20, 700 - 100 * f.getFloorNum() + 30);
                ++i;
            }
        }
    }

    public void drawElevator(Graphics g) {
        Person p;
        int c;
        int currentHeight = 700 - 100 * this.el.getCurrentFloor();
        g.setFont(this.personFont);
        g.setColor(Color.GRAY);
        g.fillRect(100, currentHeight, 100, 100);
        g.setColor(Color.BLACK);
        ArrayList<Person> toRemove = new ArrayList<Person>();
        for (Person p2 : this.el.getElevatorPersonList()) {
            if (!p2.bored()) continue;
            toRemove.add(p2);
        }
        this.el.removeAll(toRemove);
        toRemove.removeAll(toRemove);
        int i = 0;
        int r = 2;
        while (r >= 0) {
            c = 0;
            while (c < 3) {
                if (i < this.el.getElevatorPersonList().size()) {
                    p = this.el.getElevatorPersonList().get(i);
                    g.setColor(Color.BLACK);
                    g.fillRect(100 + 33 * c + 4, 33 * r + currentHeight + 4, 25, 25);
                    ++i;
                }
                ++c;
            }
            --r;
        }
        i = 0;
        g.setColor(Color.WHITE);
        r = 2;
        while (r >= 0) {
            c = 0;
            while (c < 3) {
                if (i < this.el.getElevatorPersonList().size()) {
                    p = this.el.getElevatorPersonList().get(i);
                    g.setColor(this.getDesiredColor(p, this.b));
                    g.drawString("" + p.getDesiredFloor(), 100 + 33 * c + 8 + 4, 33 * r + currentHeight + 20 + 4);
                    ++i;
                }
                ++c;
            }
            --r;
        }
        g.setColor(Color.WHITE);
        int c2 = 0;
        while (c2 < 3) {
            int r2 = 0;
            while (r2 < 3) {
                g.drawRect(100 + 33 * r2 + 4, 33 * c2 + currentHeight + 4, 25, 25);
                ++r2;
            }
            ++c2;
        }
    }

    public long getTime() {
        return this.timeElapsed;
    }

    public Color getDesiredColor(Person p, Building b) {
        return b.getFloorAtNum(p.getDesiredFloor()).getFloorColor();
    }

    public void updateTimes(long t) {
        for (Floor f : this.b.getFloorList()) {
            for (Person p : f.getFloorPersonList()) {
                p.setPatience((int)t);
            }
        }
        for (Person p : this.el.getElevatorPersonList()) {
            p.setPatience((int)t);
        }
    }

    public int getWIDTH() {
        return WIDTH;
    }

    public int getHEIGHT() {
        return HEIGHT;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 38 && this.el.getCurrentFloor() < this.b.getFloorList().size() - 1) {
            this.el.up();
        }
        if (key == 40 && this.el.getCurrentFloor() > 0) {
            this.el.down();
        }
        if (key == 32) {
            ArrayList<Person> a = this.el.swap(this.b.getFloorList().get(this.el.getCurrentFloor()));
            for (Person p : a) {
                this.points += p.getPoints();
            }
            System.out.println(this.points);
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ++this.timeElapsed;
        this.message = "" + this.timeElapsed;
        this.updateTimes(this.timeElapsed);
        Floor f1 = this.b.getFloorList().get((int)((double)this.b.getFloorList().size() * Math.random()));
        Floor f2 = this.b.getFloorList().get((int)((double)this.b.getFloorList().size() * Math.random()));
        Floor f3 = this.b.getFloorList().get((int)((double)this.b.getFloorList().size() * Math.random()));
        Person p1 = new Person(f1.getFloorNum(), this.b);
        Person p2 = new Person(f2.getFloorNum(), this.b);
        Person p3 = new Person(f3.getFloorNum(), this.b);
        p1.setStartTime(this.timeElapsed);
        p2.setStartTime(this.timeElapsed);
        p3.setStartTime(this.timeElapsed);
        f1.addPerson(p1);
        f2.addPerson(p2);
        f3.addPerson(p3);
        this.repaint();
    }
}

