import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;


public class Chick {
	private static final int RIGHT = 800;
	public static final int WIDTH=60, HEIGHT=80;
	private BufferedImage img;
	private Rectangle box;
	private int bottom, life;
	private double dx, dy;
	private boolean faceRight;
	private boolean jumping;

	public Chick (BufferedImage img, int x, int y){
		this.img = img;
		box = new Rectangle (x, y-HEIGHT, WIDTH,HEIGHT);
		dx=0D;
		dy=0D;
		bottom=y-HEIGHT;
		faceRight=true;
		jumping=false;
		life=100;
	}

	public void draw(Graphics g) {

		if(life <= 0) return;
		move();
		if(!faceRight){
			g.drawImage(img, box.x, box.y, 
					box.x+box.width, box.y+box.height, 
					0, 0, img.getWidth(), img.getHeight(), null);
		}else{
			g.drawImage(img, box.x, box.y, 
					box.x+box.width, box.y+box.height, 
					img.getWidth(), 0, 0, img.getHeight(), null);
		}	

	}
	public void hit(int amt){
		life-=amt;
		if(life<0) life=0;
	}
	public void setDx(double amt){
		dx=amt;
		if (amt>0)
			faceRight=true;
		if (amt<0)
			faceRight=false;
	}
	public void setDy(double amt){
		dy=amt;
		jumping=true;
	}
	public void move(){
		box.x=(int)(dx+box.x);
		box.y=(int)(box.y-dy);
		//make sure it not off the edges:
		if (box.y < 0) box.y=0;
		if (box.x<0) box.x=0;
		if (box.x+WIDTH>RIGHT) box.x=RIGHT-WIDTH;

		if (jumping) {
			if(box.y>=bottom){
				dy=0;
				box.y=bottom;
				jumping=false;
			}else{
				dy-=0.1;
			}

		}
	}
	public int getX(){return box.x;}
	public int getY(){return box.y;}
	public int getLife(){return life;}
	public boolean isJumping(){ return jumping&& life>0;}
	public boolean intersects(Rectangle r){return box.intersects(r);}
	public boolean isBelow(Rectangle r){
		return box.y > r.y; //head above top of cloud
	}
}