/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class CastleGraphics
extends JFrame
implements MouseListener,
KeyListener {
    private final int HEIGHT = 600;
    private final int LENGTH = 960;
    public final int BUTTON_STARTX = 750;
    public final int BUTTON_ENDX = 900;
    public final int BUTTON_STARTY = 50;
    public final int BUTTON_ENDY = 100;
    private String typeSelected;
    private String[] shells = new String[]{"Standard", "Bomb"};
    private int counter = 0;
    private BufferedImage wall;
    private BufferedImage wallBreached;
    private BufferedImage wallHalf;
    private BufferedImage wallQuarter;
    private BufferedImage winnar;
    private AudioClip boom;
    private AudioClip hit;
    private Castle castle;
    private Cannon cannon;
    private String message = "use arrow keys to change angle and power and use spacebar to fire";
    private boolean breached = false;
    private int totalCastleHealth;
    private boolean debugg = false;

    public CastleGraphics() {
        this.loadResources();
        this.updateType();
        this.newGame();
        this.setSize(960, 600);
        this.setDefaultCloseOperation(3);
        this.setTitle("Siege Game");
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setVisible(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    private void updateType() {
        this.typeSelected = "Shell: " + this.shells[this.counter];
        ++this.counter;
        if (this.counter > this.shells.length - 1) {
            this.counter = 0;
        }
    }

    public void loadResources() {
        try {
            this.wall = ImageIO.read(this.getClass().getResource("/newCastle.png"));
            this.wallHalf = ImageIO.read(this.getClass().getResource("/wallHalf.png"));
            this.wallQuarter = ImageIO.read(this.getClass().getResource("/wallQuarter.png"));
            this.wallBreached = ImageIO.read(this.getClass().getResource("/wallBreached.png"));
            this.winnar = ImageIO.read(this.getClass().getResource("/winnar.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        if (this.castle.getHealth() <= 0) {
            g.drawImage(this.wallBreached, 0, 0, null);
            this.paintWin(g);
        } else if (this.castle.getHealth() < this.totalCastleHealth / 4) {
            g.drawImage(this.wallQuarter, 0, 0, null);
            this.basicPaint(g);
        } else if (this.castle.getHealth() < this.totalCastleHealth / 2) {
            g.drawImage(this.wallHalf, 0, 0, null);
            this.basicPaint(g);
        } else {
            g.drawImage(this.wall, 0, 0, null);
            this.basicPaint(g);
        }
    }

    public void basicPaint(Graphics g) {
        g.fillRect(750, 50, 150, 50);
        g.setColor(Color.BLACK);
        g.drawString(this.typeSelected, 410, 50);
        g.drawString("Angle: " + this.cannon.getAngle() + " Power: " + this.cannon.getPower(), 410, 75);
        if (this.debugg) {
            g.drawString("Castle Health: " + this.castle.getHealth(), 410, 90);
            g.drawString("Info " + this.cannon.getWorking() + " \\ " + this.castle.getDistance() + " \\ " + this.castle.getDefenders(), 410, 110);
        }
        g.drawString(this.message, 20, 50);
        g.setColor(Color.WHITE);
        g.drawString("Change Shell", 790, 78);
    }

    public void paintWin(Graphics h) {
        h.setColor(Color.WHITE);
        h.setFont(new Font("Comic Sans", 1, 69));
        h.drawString("a winner is you!! <3", 200, 300);
    }

    public void newGame() {
        this.castle = new Castle();
        this.cannon = new Cannon();
        this.totalCastleHealth = this.castle.getHealth();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getX() >= 750 && e.getX() <= 900 && e.getY() >= 50 && e.getY() <= 100) {
            this.updateType();
            this.repaint();
        }
    }

    public boolean getHit() {
        int distance = this.cannon.getAngle() * this.cannon.getPower();
        return distance - 5 <= this.castle.getDistance() && distance + 5 >= this.castle.getDistance();
    }

    public void fire() {
        if (!this.getHit()) {
            this.message = "Missed";
        }
        if (this.cannon.getWorking() && this.getHit()) {
            if (this.counter == 1) {
                this.castle.hit(this.cannon, new StandardShot());
                this.message = "Hit for " + this.castle.getLastHit();
            }
            if (this.counter == 0) {
                this.castle.hit(this.cannon, new Bomb());
                this.message = "Hit for " + this.castle.getLastHit();
            }
        }
        if (this.counter == 0) {
            this.cannon.explode();
        }
        if (this.castle.getHealth() <= 0) {
            this.breached = true;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 38) {
            this.cannon.setAngle(this.cannon.getAngle() + 1);
            if (this.cannon.getAngle() > 10) {
                this.cannon.setAngle(0);
            }
        }
        if (key == 40) {
            this.cannon.setAngle(this.cannon.getAngle() - 1);
            if (this.cannon.getAngle() < 0) {
                this.cannon.setAngle(10);
            }
        }
        if (key == 37) {
            this.cannon.setPower(this.cannon.getPower() - 1);
            if (this.cannon.getPower() < 0) {
                this.cannon.setPower(10);
            }
        }
        if (key == 39) {
            this.cannon.setPower(this.cannon.getPower() + 1);
            if (this.cannon.getPower() > 10) {
                this.cannon.setPower(0);
            }
        }
        if (key == 32) {
            this.fire();
        }
        if (key == 192) {
            this.debugg = true;
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }
}

