/*
 * Decompiled with CFR 0.152.
 */
public class Rational {
    private int numerator;
    private int denominator;

    public Rational(String s) {
        int fBar = s.indexOf("/");
        if (fBar == -1) {
            this.numerator = Integer.parseInt(s);
            this.denominator = 1;
        } else {
            this.numerator = Integer.parseInt(s.substring(0, fBar));
            this.denominator = Integer.parseInt(s.substring(fBar + 1));
            this.simplify();
        }
    }

    public Rational(int n, int d) {
        this.numerator = n;
        this.denominator = d;
        this.simplify();
    }

    public Rational(int n) {
        this.numerator = n;
        this.denominator = 1;
    }

    public Rational() {
        this.numerator = 0;
        this.denominator = 1;
    }

    public Rational(Rational r) {
        this.numerator = r.getNumerator();
        this.denominator = r.getDenominator();
    }

    public void setNumerator(int numerator) {
        this.numerator = numerator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setDenominator(int denominator) {
        this.denominator = denominator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public double value() {
        return (double)this.numerator / (double)this.denominator;
    }

    public Rational reciprocal() {
        return new Rational(this.getDenominator(), this.getNumerator());
    }

    public String toString() {
        if (this.denominator == 1) {
            return Integer.toString(this.numerator);
        }
        return String.valueOf(Integer.toString(this.numerator)) + "/" + Integer.toString(this.denominator);
    }

    public String toString(int n) {
        String result = String.valueOf(Integer.toString(this.numerator)) + "/" + Integer.toString(this.denominator);
        if (this.denominator == 1) {
            result = Integer.toString(this.numerator);
        }
        while (result.length() < n) {
            result = " " + result;
        }
        return result;
    }

    public Rational multiply(Rational other) {
        int n = this.getNumerator() * other.getNumerator();
        int d = this.getDenominator() * other.getDenominator();
        Rational result = new Rational(n, d);
        return result;
    }

    public Rational add(Rational other) {
        int n = this.getNumerator() * other.getDenominator() + other.getNumerator() * this.getDenominator();
        int d = this.getDenominator() * other.getDenominator();
        Rational result = new Rational(n, d);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void simplify() {
        p = 2;
        if (this.denominator >= 0) ** GOTO lbl14
        this.numerator *= -1;
        this.denominator *= -1;
        ** GOTO lbl14
        {
            this.numerator /= p;
            this.denominator /= p;
            do {
                if (this.numerator % p == 0 && this.denominator % p == 0) continue block0;
                if (p == 2) {
                    ++p;
                    continue;
                }
                p += 2;
lbl14:
                // 4 sources

            } while (p <= Math.max(this.numerator, this.denominator));
        }
        if (this.numerator == 0) {
            this.denominator = 1;
        }
        if (this.numerator == this.denominator) {
            this.denominator = 1;
            this.numerator = 1;
        }
    }
}

