/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class MatrixApp
extends Frame
implements ActionListener {
    TextArea t;
    Button editButton;
    Button detButton;
    Button invButton;
    Button rrefButton;
    Button swapButton;
    Button multButton;
    Button addButton;
    Button undoButton;
    int rows;
    int cols;
    Matrix a;
    Matrix b;
    final int WIDTH = 7;
    JTextField r = new JTextField("2");
    JTextField c = new JTextField("2");

    public MatrixApp() {
        super("Matrix App 1.0");
        this.setSize(800, 600);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.t = new TextArea();
        this.t.setFont(new Font("Courier", 1, 20));
        this.t.setForeground(new Color(251, 182, 0));
        this.t.setBackground(new Color(44, 23, 0));
        this.t.setEditable(false);
        this.rows = 2;
        this.cols = 2;
        this.a = new Matrix(2, 2);
        this.parseMatrix(this.identityString(2, 2));
        this.b = new Matrix(this.a);
        this.editButton = new Button("Edit Matrix");
        this.editButton.addActionListener(this);
        this.detButton = new Button("Determinant");
        this.detButton.addActionListener(this);
        this.invButton = new Button("Inverse");
        this.invButton.addActionListener(this);
        this.rrefButton = new Button("rref");
        this.rrefButton.addActionListener(this);
        this.swapButton = new Button("Swap");
        this.swapButton.addActionListener(this);
        this.multButton = new Button("Multiply");
        this.multButton.addActionListener(this);
        this.addButton = new Button("Add a Multiple");
        this.addButton.addActionListener(this);
        this.undoButton = new Button("Undo");
        this.undoButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.t, "Center");
        Panel buttonPanel = new Panel(new FlowLayout());
        buttonPanel.add(this.editButton);
        buttonPanel.add(this.detButton);
        buttonPanel.add(this.invButton);
        buttonPanel.add(this.swapButton);
        buttonPanel.add(this.multButton);
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.rrefButton);
        buttonPanel.add(this.undoButton);
        this.add((Component)buttonPanel, "North");
    }

    public static void main(String[] args) {
        MatrixApp app = new MatrixApp();
        app.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object buttonPressed = e.getSource();
        if (buttonPressed == this.editButton) {
            this.doEditDialog();
            this.t.append("\n");
        } else if (buttonPressed == this.swapButton) {
            this.doSwapDialog();
            this.t.append("\n");
        } else if (buttonPressed == this.detButton) {
            if (this.a.getRows() != this.a.getCols()) {
                this.t.append("The determinent is undefined for non-square matrices\n");
            } else {
                this.t.append("The Determinant is " + this.a.det() + "\n");
            }
        } else if (buttonPressed == this.invButton) {
            if (this.a.getRows() != this.a.getCols()) {
                this.t.append("This matrix is not square\n");
            } else if (this.a.det().value() == 0.0) {
                this.t.append("This matrix is singular\n");
            } else {
                this.t.append("The Inverse of this matrix is \n" + Matrix.inverse(this.a).toString(7) + "\n");
            }
        } else if (buttonPressed == this.multButton) {
            this.doMultDialog();
            this.t.append("\n");
        } else if (buttonPressed == this.rrefButton) {
            Matrix d = new Matrix(this.a);
            d.rref();
            this.t.append("The row reduced echelon form of this matrix is\n" + d.toString(7) + "\n");
        } else if (buttonPressed == this.addButton) {
            this.doAddDialog();
            this.t.append("\n");
        } else if (buttonPressed == this.undoButton) {
            Matrix c = new Matrix(this.a);
            this.a = new Matrix(this.b);
            this.b = new Matrix(c);
            this.t.append("Undo selected\n" + this.a.toString(7));
        }
    }

    public String identityString(int r, int c) {
        String result = "";
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                result = i == j ? String.valueOf(result) + "1 " : String.valueOf(result) + "0 ";
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        return result;
    }

    public void doEditDialog() {
        JComponent[] order = new JComponent[]{new JLabel("rows: "), this.r, new JLabel("cols: "), this.c};
        JOptionPane.showMessageDialog(this, order, "Order of Matrix", -1);
        try {
            this.rows = Integer.parseInt(this.r.getText());
            this.cols = Integer.parseInt(this.c.getText());
            this.doMatrixDialog();
            this.t.append("\n");
        }
        catch (Exception exception) {
            this.t.append("\nHuh? try again - only one space between columns");
        }
    }

    public void doSwapDialog() {
        JTextField r1 = new JTextField("1");
        JTextField r2 = new JTextField("2");
        JComponent[] swap = new JComponent[]{new JLabel("Swap row: "), r1, new JLabel("with row: "), r2};
        JOptionPane.showMessageDialog(this, swap, "Swap 2 Rows", -1);
        try {
            int row1 = Integer.parseInt(r1.getText());
            int row2 = Integer.parseInt(r2.getText());
            this.b = new Matrix(this.a);
            this.a.swap(row1 - 1, row2 - 1);
            this.t.append("r" + row1 + " <-> r" + row2 + "\n" + this.a.toString(7));
        }
        catch (Exception exception) {
            this.t.append("\nCan't swap those rows. Try again\n");
        }
    }

    public void doMultDialog() {
        JTextField r = new JTextField("1");
        JTextField q = new JTextField("1");
        JComponent[] mult = new JComponent[]{new JLabel("Multiply row: "), r, new JLabel("by what number: "), q};
        JOptionPane.showMessageDialog(this, mult, "Multiply a Row", -1);
        try {
            int row = Integer.parseInt(r.getText());
            Rational number = new Rational(q.getText());
            this.b = new Matrix(this.a);
            this.a.multiply(row - 1, number);
            this.t.append("R" + row + " = " + number.toString() + " * r" + row + "\n" + this.a.toString(7));
        }
        catch (Exception exception) {
            this.t.append("\nSomething is wrong: bad row or malformed number. Try again\n");
        }
    }

    public void doAddDialog() {
        JTextField r1 = new JTextField("1");
        JTextField q = new JTextField("1");
        JTextField r2 = new JTextField("2");
        JComponent[] addDialog = new JComponent[]{new JLabel("Multiply row: "), r1, new JLabel("by what number: "), q, new JLabel("and add it to what row: "), r2};
        JOptionPane.showMessageDialog(this, addDialog, "Add a Multiple of a Row and Add it to Another Row", -1);
        try {
            int row1 = Integer.parseInt(r1.getText());
            int row2 = Integer.parseInt(r2.getText());
            Rational number = new Rational(q.getText());
            this.b = new Matrix(this.a);
            this.a.addMultiple(row1 - 1, number, row2 - 1);
            this.t.append("R" + row2 + " = " + number.toString() + " * r" + row1 + " + r" + row2 + "\n" + this.a.toString(7));
        }
        catch (Exception exception) {
            this.t.append("\nSomething is wrong: bad row or malformed number. Try again\n");
        }
    }

    public void doMatrixDialog() {
        String sample = this.identityString(this.rows, this.cols);
        if (this.rows == this.a.getRows() && this.cols == this.a.getCols()) {
            sample = this.a.toString();
        }
        Object[] o = new Object[1];
        TextArea m = new TextArea(sample);
        m.setFont(new Font("Courier", 1, 20));
        o[0] = m;
        int res = JOptionPane.showConfirmDialog(this, o, "Enter Matrix Values (separate columns with a single space)", 2);
        if (res == 2) {
            return;
        }
        this.parseMatrix(m.getText());
    }

    public void parseMatrix(String s) {
        this.b = new Matrix(this.a);
        this.a = new Matrix(this.rows, this.cols);
        this.t.setText("Order of this matrix is " + this.rows + " x " + this.cols + "\n");
        String[] r = s.split("\n");
        int i = 0;
        while (i < this.rows) {
            String[] c = r[i].split(" ");
            int j = 0;
            while (j < this.cols) {
                this.a.set(i, j, new Rational(c[j]));
                ++j;
            }
            ++i;
        }
        this.t.append(this.a.toString(7));
        this.t.append("\n");
    }
}

