/*
 * Decompiled with CFR 0.152.
 */
public class Matrix {
    private int rows;
    private int cols;
    Rational[][] m;

    public Matrix(int r, int c) {
        this.rows = r;
        this.cols = c;
        this.m = new Rational[this.rows][this.cols];
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                this.m[i][j] = new Rational();
                ++j;
            }
            ++i;
        }
    }

    public Matrix(Matrix o) {
        this.rows = o.getRows();
        this.cols = o.getCols();
        this.m = new Rational[this.rows][this.cols];
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                this.m[i][j] = o.get(i, j);
                ++j;
            }
            ++i;
        }
    }

    public Matrix(String s) {
        String[] r = s.split("\n");
        this.rows = r.length;
        String[] c = r[0].split(" ");
        this.cols = c.length;
        this.m = new Rational[this.rows][this.cols];
        int i = 0;
        while (i < this.rows) {
            c = r[i].split(" ");
            this.cols = c.length;
            int j = 0;
            while (j < this.cols) {
                this.set(i, j, new Rational(c[j]));
                ++j;
            }
            ++i;
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public void set(int r, int c, Rational q) {
        this.m[r][c] = q;
    }

    public Rational get(int r, int c) {
        return this.m[r][c];
    }

    public String toString() {
        String result = "";
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                result = String.valueOf(result) + this.m[i][j].toString() + " ";
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        return result;
    }

    public String toString(int n) {
        String result = "";
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                result = String.valueOf(result) + this.m[i][j].toString(n);
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        return result;
    }

    public void swap(int row1, int row2) {
        int j = 0;
        while (j < this.cols) {
            Rational q = this.get(row1, j);
            this.set(row1, j, this.get(row2, j));
            this.set(row2, j, q);
            ++j;
        }
    }

    public void multiply(int row, Rational number) {
        int j = 0;
        while (j < this.cols) {
            Rational q = number.multiply(this.get(row, j));
            this.set(row, j, q);
            ++j;
        }
    }

    public void addMultiple(int row1, Rational number, int row2) {
        int j = 0;
        while (j < this.cols) {
            Rational q = number.multiply(this.get(row1, j));
            q = q.add(this.get(row2, j));
            this.set(row2, j, q);
            ++j;
        }
    }

    public Rational det() {
        if (this.rows != this.cols) {
            return null;
        }
        return this.det(this);
    }

    public Rational det(Matrix m1) {
        if (m1.getRows() == 1) {
            return m1.get(0, 0);
        }
        Rational result = new Rational(0);
        int j = 0;
        while (j < m1.getCols()) {
            Rational cofactor = new Rational((int)Math.pow(-1.0, j));
            cofactor = cofactor.multiply(m1.get(0, j));
            cofactor = cofactor.multiply(this.det(m1.minor(0, j)));
            result = result.add(cofactor);
            ++j;
        }
        return result;
    }

    public Matrix minor(int r, int c) {
        int j;
        Matrix result = new Matrix(this.rows - 1, this.cols - 1);
        int i = 0;
        while (i < r) {
            j = 0;
            while (j < c) {
                result.set(i, j, this.get(i, j));
                ++j;
            }
            j = c + 1;
            while (j < this.cols) {
                result.set(i, j - 1, this.get(i, j));
                ++j;
            }
            ++i;
        }
        i = r + 1;
        while (i < this.rows) {
            j = 0;
            while (j < c) {
                result.set(i - 1, j, this.get(i, j));
                ++j;
            }
            j = c + 1;
            while (j < this.cols) {
                result.set(i - 1, j - 1, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void rref() {
        if (this.rows < 2) {
            return;
        }
        int i = 0;
        while (i < this.rows) {
            Rational r = this.get(i, i);
            if (r.value() != 0.0) {
                r = r.reciprocal();
            } else if (i != this.rows - 1) {
                this.swap(i, i + 1);
                r = this.get(i, i);
                if (r.value() != 0.0) {
                    r = r.reciprocal();
                }
            }
            this.multiply(i, r);
            int k = i + 1;
            while (k < this.rows) {
                Rational q = this.get(k, i);
                q = q.multiply(new Rational(-1));
                this.addMultiple(i, q, k);
                ++k;
            }
            ++i;
        }
        i = this.rows - 1;
        while (i >= 0) {
            int k = i - 1;
            while (k >= 0) {
                Rational q = this.get(k, i);
                q = q.multiply(new Rational(-1));
                this.addMultiple(i, q, k);
                --k;
            }
            --i;
        }
    }

    public static Matrix inverse(Matrix m) {
        if (m.det() == null || m.getRows() != m.getCols()) {
            return null;
        }
        Matrix aug = new Matrix(m.getRows(), 2 * m.getRows());
        int i = 0;
        while (i < aug.getRows()) {
            int j = 0;
            while (j < aug.getRows()) {
                aug.set(i, j, m.get(i, j));
                if (i == j) {
                    aug.set(i, j + aug.getRows(), new Rational(1));
                } else {
                    aug.set(i, j + aug.getRows(), new Rational(0));
                }
                ++j;
            }
            ++i;
        }
        aug.rref();
        Matrix result = new Matrix(m.getRows(), m.getRows());
        int i2 = 0;
        while (i2 < m.getRows()) {
            int j = 0;
            while (j < m.getCols()) {
                result.set(i2, j, aug.get(i2, j + m.getCols()));
                ++j;
            }
            ++i2;
        }
        return result;
    }
}

